/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeClimate;
import org.terraform.biome.BiomeSubSection;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class BiomeSection {
    private int x;
    private int z;
    public static final int bitshifts = TConfigOption.BIOME_SECTION_BITSHIFTS.getInt();
    private TerraformWorld tw;
    public static final int sectionWidth;
    public static final int minSize;
    public static final int dominanceThreshold;
    private float temperature;
    private float moisture;
    private int radius;
    private BiomeBank biome;
    private FastNoise shapeNoise;

    protected BiomeSection(TerraformWorld tw, int x, int z) {
        this.x = x >> bitshifts;
        this.z = z >> bitshifts;
        this.tw = tw;
    }

    protected BiomeSection(TerraformWorld tw, int x, int z, boolean useSectionCoords) {
        this.x = x;
        this.z = z;
        this.tw = tw;
    }

    protected void doCalculations() {
        this.radius = GenUtils.randInt(this.getSectionRandom(), minSize / 2, 5 * minSize / 4);
        this.shapeNoise = new FastNoise(Objects.hash(this.tw.getSeed(), this.x, this.z));
        this.shapeNoise.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
        this.shapeNoise.SetFractalOctaves(3);
        this.shapeNoise.SetFrequency(0.01f);
        this.biome = this.parseBiomeBank();
    }

    public static Collection<BiomeSection> getSurroundingSections(TerraformWorld tw, int width, int blockX, int blockZ) {
        int startX;
        int startZ;
        BiomeSection homeSection = BiomeBank.getBiomeSectionFromBlockCoords(tw, blockX, blockZ);
        ArrayList<BiomeSection> sections = new ArrayList<BiomeSection>();
        SimpleLocation center = homeSection.getCenter();
        if (width % 2 == 1) {
            startX = startZ = -width / 2;
        } else {
            startX = blockX >= center.getX() ? -width / 2 - 1 : -width / 2;
            startZ = blockZ >= center.getZ() ? -width / 2 - 1 : -width / 2;
        }
        for (int rx = startX; rx < startX + width; ++rx) {
            for (int rz = startZ; rz < startZ + width; ++rz) {
                sections.add(homeSection.getRelative(rx, rz));
            }
        }
        if (sections.size() != width * width) {
            TerraformGeneratorPlugin.logger.error("Section size was not " + width * width + ".");
        }
        return sections;
    }

    public static Collection<BiomeSection> getSurroundingSections(TerraformWorld tw, int blockX, int blockZ) {
        ArrayList<BiomeSection> sections = new ArrayList<BiomeSection>();
        BiomeSection homeBiome = BiomeBank.getBiomeSectionFromBlockCoords(tw, blockX, blockZ);
        sections.add(homeBiome);
        SimpleLocation center = homeBiome.getCenter();
        if (blockX >= center.getX()) {
            if (blockZ >= center.getZ()) {
                sections.add(homeBiome.getRelative(1, 0));
                sections.add(homeBiome.getRelative(1, 1));
                sections.add(homeBiome.getRelative(0, 1));
            } else {
                sections.add(homeBiome.getRelative(1, 0));
                sections.add(homeBiome.getRelative(1, -1));
                sections.add(homeBiome.getRelative(0, -1));
            }
        } else if (blockZ >= center.getZ()) {
            sections.add(homeBiome.getRelative(-1, 0));
            sections.add(homeBiome.getRelative(-1, 1));
            sections.add(homeBiome.getRelative(0, 1));
        } else {
            sections.add(homeBiome.getRelative(-1, 0));
            sections.add(homeBiome.getRelative(-1, -1));
            sections.add(homeBiome.getRelative(0, -1));
        }
        if (sections.size() != 4) {
            TerraformGeneratorPlugin.logger.error("Section size was not 4.");
        }
        return sections;
    }

    public Random getSectionRandom() {
        return new Random(Objects.hash(this.tw.getSeed(), this.x, this.z));
    }

    public Random getSectionRandom(int multiplier) {
        return new Random(multiplier * Objects.hash(this.tw.getSeed(), this.x, this.z));
    }

    public BiomeSection getRelative(int x, int z) {
        BiomeSection mc = BiomeBank.getBiomeSectionFromSectionCoords(this.tw, this.x + x, this.z + z, true);
        return mc;
    }

    public BiomeBank getBiomeBank() {
        return this.biome;
    }

    private BiomeBank parseBiomeBank() {
        this.temperature = 7.5f * this.tw.getTemperatureOctave().GetNoise(this.x, this.z);
        this.moisture = 7.5f * this.tw.getMoistureOctave().GetNoise(this.x, this.z);
        return BiomeBank.selectBiome(this, this.temperature, this.moisture);
    }

    public float getDominance(SimpleLocation target) {
        return this.getDominanceBasedOnRadius(target.getX(), target.getZ());
    }

    public float getDominanceBasedOnRadius(int blockX, int blockZ) {
        SimpleLocation center = this.getCenter();
        int xOffset = center.getX() - blockX;
        int zOffset = center.getZ() - blockZ;
        double equationResult = Math.pow(xOffset, 2.0) / Math.pow(this.radius, 2.0) + Math.pow(zOffset, 2.0) / Math.pow(this.radius, 2.0) + 0.7 * (double)this.shapeNoise.GetNoise(xOffset, zOffset);
        return (float)(1.0 - 1.0 * equationResult);
    }

    public SimpleLocation getCenter() {
        int x = (this.x << bitshifts) + sectionWidth / 2;
        int z = (this.z << bitshifts) + sectionWidth / 2;
        return new SimpleLocation(x, 0, z);
    }

    public SimpleLocation getLowerBounds() {
        int x = this.x << bitshifts;
        int z = this.z << bitshifts;
        return new SimpleLocation(x, 0, z);
    }

    public SimpleLocation getUpperBounds() {
        int x = (this.x << bitshifts) + sectionWidth;
        int z = (this.z << bitshifts) + sectionWidth;
        return new SimpleLocation(x, 0, z);
    }

    public static BiomeSection getMostDominantSection(TerraformWorld tw, int x, int z) {
        double dither = TConfigOption.BIOME_DITHER.getDouble();
        Random locationBasedRandom = new Random(Objects.hash(tw.getSeed(), x, z));
        SimpleLocation target = new SimpleLocation(x, 0, z);
        BiomeSection homeSection = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (target.distance(homeSection.getCenter()) <= (float)dominanceThreshold) {
            return homeSection;
        }
        Collection<BiomeSection> sections = BiomeSection.getSurroundingSections(tw, x, z);
        BiomeSection mostDominant = homeSection;
        for (BiomeSection sect : sections) {
            float dom = (float)((double)sect.getDominance(target) + GenUtils.randDouble(locationBasedRandom, -dither, dither));
            if (!((double)dom > (double)mostDominant.getDominance(target) + GenUtils.randDouble(locationBasedRandom, -dither, dither))) continue;
            mostDominant = sect;
        }
        return mostDominant;
    }

    public Collection<BiomeSection> getRelativeSurroundingSections(int radius) {
        if (radius == 0) {
            final BiomeSection target = this;
            return new ArrayList<BiomeSection>(){
                {
                    this.add(target);
                }
            };
        }
        ArrayList<BiomeSection> candidates = new ArrayList<BiomeSection>();
        for (int rx : new int[]{-radius, radius}) {
            for (int rz = -radius; rz <= radius; ++rz) {
                candidates.add(this.getRelative(rx, rz));
            }
        }
        for (int rz : new int[]{-radius, radius}) {
            for (int rx = 1 - radius; rx <= radius - 1; ++rx) {
                candidates.add(this.getRelative(rx, rz));
            }
        }
        return candidates;
    }

    public BiomeSubSection getSubSection(int rawX, int rawZ) {
        SimpleLocation sectionCenter = this.getCenter();
        int relXFromCenter = rawX - sectionCenter.getX();
        int relZFromCenter = rawZ - sectionCenter.getZ();
        if (relXFromCenter > 0 && relXFromCenter >= Math.abs(relZFromCenter)) {
            return BiomeSubSection.POSITIVE_X;
        }
        if (relXFromCenter <= 0 && Math.abs(relXFromCenter) >= Math.abs(relZFromCenter)) {
            return BiomeSubSection.NEGATIVE_X;
        }
        if (relZFromCenter > 0 && relZFromCenter >= Math.abs(relXFromCenter)) {
            return BiomeSubSection.POSITIVE_Z;
        }
        if (relZFromCenter <= 0 && Math.abs(relZFromCenter) >= Math.abs(relXFromCenter)) {
            return BiomeSubSection.NEGATIVE_Z;
        }
        return BiomeSubSection.NONE;
    }

    public int hashCode() {
        int prime = 13;
        int result = 5;
        result = prime * result + this.x;
        result = prime * result + this.z;
        result = prime * result + this.tw.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeSection) {
            BiomeSection BiomeSection2 = (BiomeSection)obj;
            return this.tw.getName().equals(BiomeSection2.tw.getName()) && this.x == BiomeSection2.x && this.z == BiomeSection2.z;
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "(" + this.x + "," + this.z + ")";
    }

    public BiomeClimate getClimate() {
        return BiomeClimate.selectClimate(this.temperature, this.moisture);
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getMoisture() {
        return this.moisture;
    }

    public TerraformWorld getTw() {
        return this.tw;
    }

    public double getOceanLevel() {
        return (double)this.tw.getOceanicNoise().GetNoise(this.x, this.z) * 50.0;
    }

    public double getMountainLevel() {
        return (double)this.tw.getMountainousNoise().GetNoise(this.x, this.z) * 50.0;
    }

    static {
        minSize = sectionWidth = 1 << bitshifts;
        dominanceThreshold = (int)(0.35 * (double)sectionWidth);
    }
}

