/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome;

import org.terraform.main.config.TConfigOption;
import org.terraform.utils.Range;

public enum BiomeClimate {
    HUMID_VEGETATION(Range.between(TConfigOption.CLIMATE_HUMIDVEGETATION_MINTEMP.getDouble(), TConfigOption.CLIMATE_HUMIDVEGETATION_MAXTEMP.getDouble()), Range.between(TConfigOption.CLIMATE_HUMIDVEGETATION_MINMOIST.getDouble(), TConfigOption.CLIMATE_HUMIDVEGETATION_MAXMOIST.getDouble()), 2),
    DRY_VEGETATION(Range.between(TConfigOption.CLIMATE_DRYVEGETATION_MINTEMP.getDouble(), TConfigOption.CLIMATE_DRYVEGETATION_MAXTEMP.getDouble()), Range.between(TConfigOption.CLIMATE_DRYVEGETATION_MINMOIST.getDouble(), TConfigOption.CLIMATE_DRYVEGETATION_MAXMOIST.getDouble()), 1),
    HOT_BARREN(Range.between(TConfigOption.CLIMATE_HOTBARREN_MINTEMP.getDouble(), TConfigOption.CLIMATE_HOTBARREN_MAXTEMP.getDouble()), Range.between(TConfigOption.CLIMATE_HOTBARREN_MINMOIST.getDouble(), TConfigOption.CLIMATE_HOTBARREN_MAXMOIST.getDouble()), 2),
    COLD(Range.between(TConfigOption.CLIMATE_COLD_MINTEMP.getDouble(), TConfigOption.CLIMATE_COLD_MAXTEMP.getDouble()), Range.between(TConfigOption.CLIMATE_COLD_MINMOIST.getDouble(), TConfigOption.CLIMATE_COLD_MAXMOIST.getDouble()), 1),
    SNOWY(Range.between(TConfigOption.CLIMATE_SNOWY_MINTEMP.getDouble(), TConfigOption.CLIMATE_SNOWY_MAXTEMP.getDouble()), Range.between(TConfigOption.CLIMATE_SNOWY_MINMOIST.getDouble(), TConfigOption.CLIMATE_SNOWY_MAXMOIST.getDouble()), 2),
    TRANSITION(Range.between(-4.0, 4.0), Range.between(-4.0, 4.0), 0);

    Range<Double> temperatureRange;
    Range<Double> moistureRange;
    int priority;

    private BiomeClimate(Range<Double> temperatureRange, Range<Double> moistureRange, int priority) {
        this.temperatureRange = temperatureRange;
        this.moistureRange = moistureRange;
        this.priority = priority;
    }

    public Range<Double> getTemperatureRange() {
        return this.temperatureRange;
    }

    public Range<Double> getMoistureRange() {
        return this.moistureRange;
    }

    private static boolean isInRange(double val, Range<Double> r) {
        return r.getMaximum() >= val && r.getMinimum() <= val;
    }

    public static BiomeClimate selectClimate(double temp, double moist) {
        BiomeClimate candidate = TRANSITION;
        for (BiomeClimate climate : BiomeClimate.values()) {
            if (!BiomeClimate.isInRange(temp, climate.getTemperatureRange()) || !BiomeClimate.isInRange(moist, climate.getMoistureRange())) continue;
            if (candidate == null) {
                candidate = climate;
                continue;
            }
            if (candidate.priority >= climate.priority) continue;
            candidate = climate;
        }
        return candidate;
    }
}

