/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.terraform.biome.BiomeClimate;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeSectionCacheLoader;
import org.terraform.biome.BiomeType;
import org.terraform.biome.HeightIndependentBiomeCacheLoader;
import org.terraform.biome.beach.BadlandsBeachHandler;
import org.terraform.biome.beach.BlackOceanBeachHandler;
import org.terraform.biome.beach.BogBeachHandler;
import org.terraform.biome.beach.CherryGroveBeachHandler;
import org.terraform.biome.beach.DarkForestBeachHandler;
import org.terraform.biome.beach.IcyBeachHandler;
import org.terraform.biome.beach.MudflatsHandler;
import org.terraform.biome.beach.MushroomBeachHandler;
import org.terraform.biome.beach.RockBeachHandler;
import org.terraform.biome.beach.SandyBeachHandler;
import org.terraform.biome.beach.ScarletForestBeachHandler;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.biome.cave.ForestedMountainsCavePopulator;
import org.terraform.biome.cave.FrozenCavePopulator;
import org.terraform.biome.cave.MossyCavePopulator;
import org.terraform.biome.flat.ArchedCliffsHandler;
import org.terraform.biome.flat.BadlandsHandler;
import org.terraform.biome.flat.BambooForestHandler;
import org.terraform.biome.flat.CherryGroveHandler;
import org.terraform.biome.flat.DarkForestHandler;
import org.terraform.biome.flat.DesertHandler;
import org.terraform.biome.flat.ElevatedPlainsHandler;
import org.terraform.biome.flat.ErodedPlainsHandler;
import org.terraform.biome.flat.ForestHandler;
import org.terraform.biome.flat.GorgeHandler;
import org.terraform.biome.flat.IceSpikesHandler;
import org.terraform.biome.flat.JungleHandler;
import org.terraform.biome.flat.MuddyBogHandler;
import org.terraform.biome.flat.PetrifiedCliffsHandler;
import org.terraform.biome.flat.PlainsHandler;
import org.terraform.biome.flat.SavannaHandler;
import org.terraform.biome.flat.ScarletForestHandler;
import org.terraform.biome.flat.SnowyTaigaHandler;
import org.terraform.biome.flat.SnowyWastelandHandler;
import org.terraform.biome.flat.TaigaHandler;
import org.terraform.biome.mountainous.BadlandsCanyonHandler;
import org.terraform.biome.mountainous.BirchMountainsHandler;
import org.terraform.biome.mountainous.DesertHillsHandler;
import org.terraform.biome.mountainous.ForestedMountainsHandler;
import org.terraform.biome.mountainous.JaggedPeaksHandler;
import org.terraform.biome.mountainous.PaintedHillsHandler;
import org.terraform.biome.mountainous.RockyMountainsHandler;
import org.terraform.biome.mountainous.ShatteredSavannaHandler;
import org.terraform.biome.mountainous.SnowyMountainsHandler;
import org.terraform.biome.ocean.BlackOceansHandler;
import org.terraform.biome.ocean.ColdOceansHandler;
import org.terraform.biome.ocean.CoralReefOceanHandler;
import org.terraform.biome.ocean.FrozenOceansHandler;
import org.terraform.biome.ocean.LukewarmOceansHandler;
import org.terraform.biome.ocean.MushroomIslandHandler;
import org.terraform.biome.ocean.OceansHandler;
import org.terraform.biome.ocean.SwampHandler;
import org.terraform.biome.ocean.WarmOceansHandler;
import org.terraform.biome.river.BadlandsRiverHandler;
import org.terraform.biome.river.BogRiverHandler;
import org.terraform.biome.river.CherryGroveRiverHandler;
import org.terraform.biome.river.DarkForestRiverHandler;
import org.terraform.biome.river.DesertRiverHandler;
import org.terraform.biome.river.FrozenRiverHandler;
import org.terraform.biome.river.JungleRiverHandler;
import org.terraform.biome.river.RiverHandler;
import org.terraform.biome.river.ScarletForestRiverHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.TWSimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public enum BiomeBank {
    SNOWY_MOUNTAINS(new SnowyMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.SNOWY, TConfigOption.BIOME_SNOWY_MOUNTAINS_WEIGHT.getInt(), new FrozenCavePopulator()),
    BIRCH_MOUNTAINS((BiomeHandler)new BirchMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.COLD, TConfigOption.BIOME_BIRCH_MOUNTAINS_WEIGHT.getInt()),
    ROCKY_MOUNTAINS((BiomeHandler)new RockyMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.TRANSITION, TConfigOption.BIOME_ROCKY_MOUNTAINS_WEIGHT.getInt()),
    FORESTED_MOUNTAINS(new ForestedMountainsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_FORESTED_MOUNTAINS_WEIGHT.getInt(), new ForestedMountainsCavePopulator()),
    SHATTERED_SAVANNA((BiomeHandler)new ShatteredSavannaHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_SHATTERED_SAVANNA_WEIGHT.getInt()),
    PAINTED_HILLS((BiomeHandler)new PaintedHillsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_PAINTED_HILLS_WEIGHT.getInt()),
    BADLANDS_CANYON((BiomeHandler)new BadlandsCanyonHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_BADLANDS_MOUNTAINS_WEIGHT.getInt()),
    DESERT_MOUNTAINS((BiomeHandler)new DesertHillsHandler(), BiomeType.MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_DESERT_MOUNTAINS_WEIGHT.getInt()),
    JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.SNOWY, TConfigOption.BIOME_JAGGED_PEAKS_WEIGHT.getInt(), new FrozenCavePopulator()),
    COLD_JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.COLD, TConfigOption.BIOME_JAGGED_PEAKS_WEIGHT.getInt(), new FrozenCavePopulator()),
    TRANSITION_JAGGED_PEAKS(new JaggedPeaksHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.TRANSITION, TConfigOption.BIOME_JAGGED_PEAKS_WEIGHT.getInt(), new FrozenCavePopulator()),
    FORESTED_PEAKS(new ForestedMountainsHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_FORESTED_MOUNTAINS_WEIGHT.getInt(), new ForestedMountainsCavePopulator()),
    SHATTERED_SAVANNA_PEAK((BiomeHandler)new ShatteredSavannaHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_SHATTERED_SAVANNA_WEIGHT.getInt()),
    BADLANDS_CANYON_PEAK((BiomeHandler)new BadlandsCanyonHandler(), BiomeType.HIGH_MOUNTAINOUS, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_BADLANDS_MOUNTAINS_WEIGHT.getInt()),
    OCEAN((BiomeHandler)new OceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.TRANSITION, TConfigOption.BIOME_OCEAN_WEIGHT.getInt()),
    BLACK_OCEAN((BiomeHandler)new BlackOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.TRANSITION, TConfigOption.BIOME_BLACK_OCEAN_WEIGHT.getInt()),
    COLD_OCEAN((BiomeHandler)new ColdOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.COLD, TConfigOption.BIOME_COLD_OCEAN_WEIGHT.getInt()),
    FROZEN_OCEAN(new FrozenOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.SNOWY, TConfigOption.BIOME_FROZEN_OCEAN_WEIGHT.getInt(), new FrozenCavePopulator()),
    WARM_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_WARM_OCEAN_WEIGHT.getInt()),
    HUMID_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_HUMID_OCEAN_WEIGHT.getInt()),
    DRY_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_DRY_OCEAN_WEIGHT.getInt()),
    CORAL_REEF_OCEAN((BiomeHandler)new CoralReefOceanHandler(BiomeType.OCEANIC), BiomeType.OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_CORALREEF_OCEAN_WEIGHT.getInt()),
    RIVER(new RiverHandler(), BiomeType.RIVER, BiomeClimate.TRANSITION),
    BOG_RIVER(new BogRiverHandler(), BiomeType.RIVER, BiomeClimate.DRY_VEGETATION),
    CHERRY_GROVE_RIVER(new CherryGroveRiverHandler(), BiomeType.RIVER, BiomeClimate.COLD),
    SCARLET_FOREST_RIVER(new ScarletForestRiverHandler(), BiomeType.RIVER, BiomeClimate.COLD),
    JUNGLE_RIVER(new JungleRiverHandler(), BiomeType.RIVER, BiomeClimate.HUMID_VEGETATION),
    FROZEN_RIVER((BiomeHandler)new FrozenRiverHandler(), BiomeType.RIVER, BiomeClimate.SNOWY, new FrozenCavePopulator()),
    DARK_FOREST_RIVER((BiomeHandler)new DarkForestRiverHandler(), BiomeType.RIVER, BiomeClimate.HUMID_VEGETATION, new FrozenCavePopulator()),
    DESERT_RIVER(new DesertRiverHandler(), BiomeType.RIVER, BiomeClimate.HOT_BARREN),
    BADLANDS_RIVER(new BadlandsRiverHandler(), BiomeType.RIVER, BiomeClimate.HOT_BARREN),
    DEEP_OCEAN((BiomeHandler)new OceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfigOption.BIOME_DEEP_OCEAN_WEIGHT.getInt()),
    DEEP_COLD_OCEAN((BiomeHandler)new ColdOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.COLD, TConfigOption.BIOME_DEEP_COLD_OCEAN_WEIGHT.getInt()),
    DEEP_BLACK_OCEAN((BiomeHandler)new BlackOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfigOption.BIOME_DEEP_BLACK_OCEAN_WEIGHT.getInt()),
    DEEP_FROZEN_OCEAN(new FrozenOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.SNOWY, TConfigOption.BIOME_DEEP_FROZEN_OCEAN_WEIGHT.getInt(), new FrozenCavePopulator()),
    DEEP_WARM_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_DEEP_WARM_OCEAN_WEIGHT.getInt()),
    DEEP_HUMID_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_DEEP_HUMID_OCEAN_WEIGHT.getInt()),
    DEEP_DRY_OCEAN((BiomeHandler)new WarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_DEEP_DRY_OCEAN_WEIGHT.getInt()),
    DEEP_LUKEWARM_OCEAN((BiomeHandler)new LukewarmOceansHandler(BiomeType.DEEP_OCEANIC), BiomeType.DEEP_OCEANIC, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_DEEP_LUKEWARM_OCEAN_WEIGHT.getInt()),
    MUSHROOM_ISLANDS((BiomeHandler)new MushroomIslandHandler(), BiomeType.DEEP_OCEANIC, BiomeClimate.TRANSITION, TConfigOption.BIOME_MUSHROOM_ISLAND_WEIGHT.getInt()),
    PLAINS((BiomeHandler)new PlainsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfigOption.BIOME_PLAINS_WEIGHT.getInt()),
    ELEVATED_PLAINS((BiomeHandler)new ElevatedPlainsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfigOption.BIOME_ELEVATED_PLAINS_WEIGHT.getInt()),
    GORGE((BiomeHandler)new GorgeHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfigOption.BIOME_GORGE_WEIGHT.getInt()),
    PETRIFIED_CLIFFS((BiomeHandler)new PetrifiedCliffsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfigOption.BIOME_PETRIFIEDCLIFFS_WEIGHT.getInt()),
    ARCHED_CLIFFS((BiomeHandler)new ArchedCliffsHandler(), BiomeType.FLAT, BiomeClimate.TRANSITION, TConfigOption.BIOME_ARCHED_CLIFFS_WEIGHT.getInt()),
    SAVANNA((BiomeHandler)new SavannaHandler(), BiomeType.FLAT, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_SAVANNA_WEIGHT.getInt()),
    MUDDY_BOG((BiomeHandler)new MuddyBogHandler(), BiomeType.FLAT, BiomeClimate.DRY_VEGETATION, TConfigOption.BIOME_MUDDYBOG_WEIGHT.getInt()),
    FOREST((BiomeHandler)new ForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_FOREST_WEIGHT.getInt()),
    JUNGLE((BiomeHandler)new JungleHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_JUNGLE_WEIGHT.getInt()),
    BAMBOO_FOREST((BiomeHandler)new BambooForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_BAMBOO_FOREST_WEIGHT.getInt()),
    DESERT((BiomeHandler)new DesertHandler(), BiomeType.FLAT, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_DESERT_WEIGHT.getInt()),
    BADLANDS((BiomeHandler)new BadlandsHandler(), BiomeType.FLAT, BiomeClimate.HOT_BARREN, TConfigOption.BIOME_BADLANDS_WEIGHT.getInt()),
    ERODED_PLAINS((BiomeHandler)new ErodedPlainsHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfigOption.BIOME_ERODED_PLAINS_WEIGHT.getInt()),
    SCARLET_FOREST((BiomeHandler)new ScarletForestHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfigOption.BIOME_SCARLETFOREST_WEIGHT.getInt()),
    CHERRY_GROVE((BiomeHandler)new CherryGroveHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfigOption.BIOME_CHERRYGROVE_WEIGHT.getInt()),
    TAIGA((BiomeHandler)new TaigaHandler(), BiomeType.FLAT, BiomeClimate.COLD, TConfigOption.BIOME_TAIGA_WEIGHT.getInt()),
    SNOWY_TAIGA(new SnowyTaigaHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfigOption.BIOME_SNOWY_TAIGA_WEIGHT.getInt(), new FrozenCavePopulator()),
    SNOWY_WASTELAND(new SnowyWastelandHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfigOption.BIOME_SNOWY_WASTELAND_WEIGHT.getInt(), new FrozenCavePopulator()),
    ICE_SPIKES(new IceSpikesHandler(), BiomeType.FLAT, BiomeClimate.SNOWY, TConfigOption.BIOME_ICE_SPIKES_WEIGHT.getInt(), new FrozenCavePopulator()),
    DARK_FOREST((BiomeHandler)new DarkForestHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_DARK_FOREST_WEIGHT.getInt()),
    SWAMP((BiomeHandler)new SwampHandler(), BiomeType.FLAT, BiomeClimate.HUMID_VEGETATION, TConfigOption.BIOME_SWAMP_WEIGHT.getInt()),
    SANDY_BEACH(new SandyBeachHandler(), BiomeType.BEACH, BiomeClimate.TRANSITION),
    BOG_BEACH(new BogBeachHandler(), BiomeType.BEACH, BiomeClimate.DRY_VEGETATION),
    DARK_FOREST_BEACH(new DarkForestBeachHandler(), BiomeType.BEACH, BiomeClimate.HUMID_VEGETATION),
    BADLANDS_BEACH(new BadlandsBeachHandler(), BiomeType.BEACH, BiomeClimate.HOT_BARREN),
    MUSHROOM_BEACH(new MushroomBeachHandler(), BiomeType.BEACH, BiomeClimate.TRANSITION),
    BLACK_OCEAN_BEACH(new BlackOceanBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    ROCKY_BEACH(new RockBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    ICY_BEACH((BiomeHandler)new IcyBeachHandler(), BiomeType.BEACH, BiomeClimate.SNOWY, new FrozenCavePopulator()),
    MUDFLATS(new MudflatsHandler(), BiomeType.BEACH, BiomeClimate.HUMID_VEGETATION),
    CHERRY_GROVE_BEACH(new CherryGroveBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD),
    SCARLET_FOREST_BEACH(new ScarletForestBeachHandler(), BiomeType.BEACH, BiomeClimate.COLD);

    public static boolean debugPrint;
    public static final ArrayList<BiomeBank> FLAT;
    private final BiomeHandler handler;
    private final BiomeType type;
    private final AbstractCavePopulator cavePop;
    private final BiomeClimate climate;
    private int biomeWeight;
    private static final LoadingCache<BiomeSection, BiomeSection> BIOMESECTION_CACHE;
    private static final LoadingCache<TWSimpleLocation, BiomeBank> HEIGHTINDEPENDENTBIOME_CACHE;
    public static BiomeBank singleLand;
    public static BiomeBank singleOcean;
    public static BiomeBank singleDeepOcean;
    public static BiomeBank singleMountain;
    public static BiomeBank singleHighMountain;

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = 0;
        this.cavePop = new MossyCavePopulator();
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, AbstractCavePopulator cavePop) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = 0;
        this.cavePop = cavePop;
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, int biomeWeight) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.biomeWeight = biomeWeight;
        this.cavePop = new MossyCavePopulator();
    }

    private BiomeBank(BiomeHandler handler, BiomeType type, BiomeClimate climate, int biomeWeight, AbstractCavePopulator cavePop) {
        this.handler = handler;
        this.type = type;
        this.climate = climate;
        this.cavePop = cavePop;
        this.biomeWeight = biomeWeight;
    }

    public static BiomeSection getBiomeSectionFromBlockCoords(TerraformWorld tw, int x, int z) {
        BiomeSection sect = new BiomeSection(tw, x, z);
        try {
            sect = (BiomeSection)BIOMESECTION_CACHE.getUnchecked((Object)sect);
        }
        catch (Throwable e) {
            e.printStackTrace();
            sect.doCalculations();
        }
        return sect;
    }

    public static BiomeSection getBiomeSectionFromChunk(TerraformWorld tw, int chunkX, int chunkZ) {
        BiomeSection sect = new BiomeSection(tw, chunkX << 4, chunkZ << 4);
        try {
            sect = (BiomeSection)BIOMESECTION_CACHE.getUnchecked((Object)sect);
        }
        catch (Throwable e) {
            e.printStackTrace();
            sect.doCalculations();
        }
        return sect;
    }

    public static BiomeSection getBiomeSectionFromSectionCoords(TerraformWorld tw, int x, int z, boolean useSectionCoords) {
        BiomeSection sect = new BiomeSection(tw, x, z, useSectionCoords);
        try {
            sect = (BiomeSection)BIOMESECTION_CACHE.getUnchecked((Object)sect);
        }
        catch (Throwable e) {
            e.printStackTrace();
            sect.doCalculations();
        }
        return sect;
    }

    public static BiomeBank calculateBiome(TerraformWorld tw, int rawX, int height, int rawZ) {
        if (debugPrint) {
            TerraformGeneratorPlugin.logger.info("calculateBiome called with args: " + tw.getName() + "," + rawX + "," + height + "," + rawZ);
        }
        BiomeBank bank = BiomeBank.calculateHeightIndependentBiome(tw, rawX, rawZ);
        FastNoise beachNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BEACH_HEIGHT, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
            n.SetFrequency(0.01f);
            n.SetFractalOctaves(4);
            return n;
        });
        if (height < TerraformGenerator.seaLevel && (double)height + HeightMap.getRawRiverDepth(tw, rawX, rawZ) >= (double)TerraformGenerator.seaLevel) {
            bank = bank.getHandler().getRiverType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> River Detected");
            }
        } else if (height >= TerraformGenerator.seaLevel && (float)height <= (float)TerraformGenerator.seaLevel + 8.0f * Math.abs(beachNoise.GetNoise(rawX, rawZ))) {
            bank = bank.getHandler().getBeachType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Beach calculated");
            }
        }
        if (bank != SWAMP && height < TerraformGenerator.seaLevel && bank.getType().isDry()) {
            bank = bank.getHandler().getRiverType();
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Biome is submerged, defaulting to river");
            }
        }
        if (!bank.getType().isDry() && height >= TerraformGenerator.seaLevel) {
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> Submerged biome above ground detected");
            }
            BiomeBank replacement = null;
            if (!bank.getHandler().forceDefaultToBeach()) {
                int highestDom = Integer.MIN_VALUE;
                for (BiomeSection sect : BiomeSection.getSurroundingSections(tw, rawX, rawZ)) {
                    if (debugPrint) {
                        TerraformGeneratorPlugin.logger.info("calculateBiome -> -> Comparison Section: " + sect.toString());
                    }
                    if (!sect.getBiomeBank().getType().isDry()) continue;
                    int compDist = (int)sect.getDominanceBasedOnRadius(rawX, rawZ);
                    if (debugPrint) {
                        TerraformGeneratorPlugin.logger.info("calculateBiome -> -> -> Dominance: " + compDist);
                    }
                    if (compDist <= highestDom) continue;
                    replacement = sect.getBiomeBank();
                    highestDom = compDist;
                }
            }
            bank = replacement == null ? bank.getHandler().getBeachType() : replacement;
            if (debugPrint) {
                TerraformGeneratorPlugin.logger.info("calculateBiome -> -> Submerged biome defaulted to: " + replacement);
            }
        }
        if (debugPrint) {
            TerraformGeneratorPlugin.logger.info("calculateBiome -> Evaluated: " + bank);
        }
        return bank;
    }

    public static BiomeBank calculateHeightIndependentBiome(TerraformWorld tw, int x, int z) {
        BiomeBank bank;
        TWSimpleLocation loc = new TWSimpleLocation(tw, x, 0, z);
        try {
            bank = (BiomeBank)((Object)HEIGHTINDEPENDENTBIOME_CACHE.getUnchecked((Object)loc));
        }
        catch (Throwable e) {
            e.printStackTrace();
            bank = PLAINS;
        }
        return bank;
    }

    public static void initSinglesConfig() {
        try {
            singleLand = BiomeBank.valueOf(TConfigOption.BIOME_SINGLE_TERRESTRIAL_TYPE.getString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            singleLand = null;
        }
        try {
            singleOcean = BiomeBank.valueOf(TConfigOption.BIOME_SINGLE_OCEAN_TYPE.getString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            singleOcean = null;
        }
        try {
            singleDeepOcean = BiomeBank.valueOf(TConfigOption.BIOME_SINGLE_DEEPOCEAN_TYPE.getString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            singleDeepOcean = null;
        }
        try {
            singleMountain = BiomeBank.valueOf(TConfigOption.BIOME_SINGLE_MOUNTAIN_TYPE.getString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            singleMountain = null;
        }
        try {
            singleHighMountain = BiomeBank.valueOf(TConfigOption.BIOME_SINGLE_HIGHMOUNTAIN_TYPE.getString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            singleHighMountain = null;
        }
    }

    public static boolean isBiomeEnabled(BiomeBank bank) {
        if (bank.getBiomeWeight() <= 0) {
            return false;
        }
        switch (bank.getType()) {
            case BEACH: {
                return true;
            }
            case DEEP_OCEANIC: {
                return singleDeepOcean == null || singleDeepOcean == bank;
            }
            case FLAT: {
                return singleLand == null || singleLand == bank;
            }
            case HIGH_MOUNTAINOUS: {
                return singleHighMountain == null || singleHighMountain == bank;
            }
            case MOUNTAINOUS: {
                return singleMountain == null || singleMountain == bank;
            }
            case OCEANIC: {
                return singleOcean == null || singleOcean == bank;
            }
            case RIVER: {
                return true;
            }
        }
        return true;
    }

    public static BiomeBank selectBiome(BiomeSection section, double temperature, double moisture) {
        Random sectionRand = section.getSectionRandom();
        BiomeType targetType = null;
        BiomeClimate climate = BiomeClimate.selectClimate(temperature, moisture);
        double oceanicNoise = section.getOceanLevel();
        if (oceanicNoise < 0.0) {
            if ((oceanicNoise = Math.abs(oceanicNoise)) >= (double)TConfigOption.BIOME_DEEP_OCEANIC_THRESHOLD.getFloat()) {
                targetType = BiomeType.DEEP_OCEANIC;
            } else if (oceanicNoise >= (double)TConfigOption.BIOME_OCEANIC_THRESHOLD.getFloat()) {
                targetType = BiomeType.OCEANIC;
            }
        } else {
            double mountainousNoise = section.getMountainLevel();
            if (mountainousNoise > 0.0) {
                if (mountainousNoise >= (double)TConfigOption.BIOME_HIGH_MOUNTAINOUS_THRESHOLD.getFloat()) {
                    targetType = BiomeType.HIGH_MOUNTAINOUS;
                } else if (mountainousNoise >= (double)TConfigOption.BIOME_MOUNTAINOUS_THRESHOLD.getFloat()) {
                    targetType = BiomeType.MOUNTAINOUS;
                }
            }
        }
        if (targetType == BiomeType.OCEANIC && singleOcean != null) {
            return singleOcean;
        }
        if (targetType == BiomeType.DEEP_OCEANIC && singleDeepOcean != null) {
            return singleDeepOcean;
        }
        if (targetType == null && singleLand != null) {
            return singleLand;
        }
        if (targetType == BiomeType.MOUNTAINOUS && singleMountain != null) {
            return singleMountain;
        }
        if (targetType == BiomeType.HIGH_MOUNTAINOUS && singleHighMountain != null) {
            return singleHighMountain;
        }
        ArrayList<BiomeBank> contenders = new ArrayList<BiomeBank>();
        for (BiomeBank biome : BiomeBank.values()) {
            if (biome.biomeWeight <= 0 || (targetType == null ? biome.getType() == BiomeType.DEEP_OCEANIC || biome.getType() == BiomeType.OCEANIC || biome.getType() == BiomeType.MOUNTAINOUS || biome.getType() == BiomeType.HIGH_MOUNTAINOUS : targetType != biome.getType())) continue;
            if (biome.climate != climate) continue;
            for (int i = 0; i < biome.biomeWeight; ++i) {
                contenders.add(biome);
            }
        }
        Collections.shuffle(contenders, sectionRand);
        if (contenders.size() == 0) {
            switch (targetType) {
                case BEACH: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for beach: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_BEACH.getString());
                }
                case DEEP_OCEANIC: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for deep oceanic: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_DEEPOCEANIC.getString());
                }
                case FLAT: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for flat: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_FLAT.getString());
                }
                case MOUNTAINOUS: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for mountainous: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_MOUNTAINOUS.getString());
                }
                case OCEANIC: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for ocean: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_OCEANIC.getString());
                }
                case RIVER: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for river: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_RIVER.getString());
                }
                case HIGH_MOUNTAINOUS: {
                    TerraformGeneratorPlugin.logger.info("Defaulted for high mountainous: " + temperature + " : " + moisture + "," + climate + ":" + targetType);
                    return BiomeBank.valueOf(TConfigOption.BIOME_DEFAULT_HIGHMOUNTAINOUS.getString());
                }
            }
        } else {
            return (BiomeBank)((Object)contenders.get(0));
        }
        return null;
    }

    public AbstractCavePopulator getCavePop() {
        return this.cavePop;
    }

    public BiomeType getType() {
        return this.type;
    }

    public BiomeHandler getHandler() {
        return this.handler;
    }

    public BiomeClimate getClimate() {
        return this.climate;
    }

    public int getBiomeWeight() {
        return this.biomeWeight;
    }

    static {
        debugPrint = false;
        FLAT = new ArrayList<BiomeBank>(){
            {
                for (BiomeBank b : BiomeBank.values()) {
                    if (b.getType() != BiomeType.FLAT) continue;
                    this.add(b);
                }
            }
        };
        BIOMESECTION_CACHE = CacheBuilder.newBuilder().maximumSize(250L).build((CacheLoader)new BiomeSectionCacheLoader());
        HEIGHTINDEPENDENTBIOME_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new HeightIndependentBiomeCacheLoader());
        singleLand = null;
        singleOcean = null;
        singleDeepOcean = null;
        singleMountain = null;
        singleHighMountain = null;
    }
}

