/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.loaders;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.ConfigurationSection;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;

public class LocalizationsLoader {
    private static final String[] translationsResources = new String[]{"en.yml", "ru.yml", "pt.yml"};
    private final TemporaryWhiteList plugin;

    public LocalizationsLoader(TemporaryWhiteList pluginInstance) {
        this.plugin = pluginInstance;
    }

    public void copyDefaultTranslations() {
        File translationsDirectory = new File(this.plugin.getDataFolder(), "./translations/");
        if (!translationsDirectory.exists() && !translationsDirectory.mkdir()) {
            throw new RuntimeException("Directory for translations couldn't created.");
        }
        for (String translationsResource : translationsResources) {
            File translationFile = new File(translationsDirectory, translationsResource);
            if (translationFile.exists()) continue;
            try (InputStream resource = this.plugin.getResource("translations/" + translationsResource);){
                Files.copy(resource, translationFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't load " + translationsResource + " from plugin jar. Is it corrupted?", e);
            }
        }
    }

    public MessagesConfig loadMessages() {
        try {
            return new MessagesConfig((ConfigurationSection)YamlConfig.loadOrCreate("translations/" + this.plugin.getConfiguration().Translation, this.plugin));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Can't load translation file", e);
        }
    }
}

