/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.lib.yaml.common.text;

import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import ru.reosfire.temporarywhitelist.lib.text.IColorizer;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;
import ru.reosfire.temporarywhitelist.lib.text.Text;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;
import ru.reosfire.temporarywhitelist.lib.yaml.common.text.ClickConfig;
import ru.reosfire.temporarywhitelist.lib.yaml.common.text.HoverConfig;

public class TextComponentConfig
extends YamlConfig {
    public final String TextContent;
    public final List<TextComponentConfig> Content;
    public final ClickConfig ClickConfig;
    public final HoverConfig HoverConfig;
    public final ChatColor Color;
    public final boolean Bold;
    public final boolean Italic;
    public final boolean Strikethrough;
    public final boolean Underlined;

    public TextComponentConfig(ConfigurationSection configurationSection) {
        super(configurationSection);
        if (this.isList("Content")) {
            this.Content = this.getList(TextComponentConfig::new, "Content");
            this.TextContent = null;
        } else {
            this.TextContent = this.getColoredString("Content", null);
            this.Content = null;
        }
        ConfigurationSection clickSection = this.getSection("Click", null);
        this.ClickConfig = clickSection == null ? null : new ClickConfig(clickSection);
        ConfigurationSection hoverSection = this.getSection("Hover", null);
        this.HoverConfig = hoverSection == null ? null : new HoverConfig(hoverSection);
        String color = this.getString("Color");
        this.Color = color == null ? null : ChatColor.valueOf((String)color.toUpperCase(Locale.ROOT));
        this.Bold = this.getBoolean("Bold", false);
        this.Italic = this.getBoolean("Italic", false);
        this.Strikethrough = this.getBoolean("Strikethrough", false);
        this.Underlined = this.getBoolean("Underlined", false);
    }

    public void Send(CommandSender receiver, Replacement ... replacements) {
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            player.spigot().sendMessage((BaseComponent)this.Unwrap((OfflinePlayer)player, replacements));
        } else {
            receiver.sendMessage(this.toString(replacements));
        }
    }

    public TextComponent Unwrap(OfflinePlayer player, Replacement ... replacements) {
        return this.Unwrap(s -> Text.colorize(player, s, replacements));
    }

    public TextComponent Unwrap(IColorizer colorizer) {
        TextComponent result;
        if (this.Content == null) {
            result = new TextComponent(TextComponent.fromLegacyText((String)colorizer.colorize(this.TextContent)));
        } else {
            TextComponent[] subComponents = new TextComponent[this.Content.size()];
            for (int i = 0; i < subComponents.length; ++i) {
                subComponents[i] = this.Content.get(i).Unwrap(colorizer);
            }
            result = new TextComponent((BaseComponent[])subComponents);
        }
        if (this.ClickConfig != null) {
            result.setClickEvent(this.ClickConfig.Unwrap(colorizer));
        }
        if (this.HoverConfig != null) {
            result.setHoverEvent(this.HoverConfig.Unwrap(colorizer));
        }
        if (this.Color != null) {
            result.setColor(this.Color);
        }
        result.setBold(Boolean.valueOf(this.Bold));
        result.setItalic(Boolean.valueOf(this.Italic));
        result.setUnderlined(Boolean.valueOf(this.Underlined));
        result.setStrikethrough(Boolean.valueOf(this.Strikethrough));
        return result;
    }

    public String toString(Replacement ... replacements) {
        if (this.TextContent != null) {
            return Text.setColors(Replacement.set(this.TextContent, replacements));
        }
        StringBuilder resultBuilder = new StringBuilder();
        for (TextComponentConfig subComponent : this.Content) {
            resultBuilder.append(subComponent.toString(replacements));
        }
        return Text.setColors(resultBuilder.toString());
    }

    public String toString() {
        if (this.TextContent != null) {
            return this.TextContent;
        }
        StringBuilder resultBuilder = new StringBuilder();
        for (TextComponentConfig subComponent : this.Content) {
            resultBuilder.append(subComponent.toString());
        }
        return resultBuilder.toString();
    }
}

