/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.lib.yaml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.reosfire.temporarywhitelist.lib.text.Text;
import ru.reosfire.temporarywhitelist.lib.yaml.IConfigCreator;
import ru.reosfire.temporarywhitelist.lib.yaml.common.text.MultilineMessage;
import ru.reosfire.temporarywhitelist.lib.yaml.common.text.TextComponentConfig;

public abstract class YamlConfig {
    protected final ConfigurationSection configurationSection;

    public static YamlConfiguration loadOrCreate(String resultFileName, String defaultConfigurationResource, JavaPlugin plugin) throws IOException, InvalidConfigurationException {
        YamlConfiguration config = new YamlConfiguration();
        config.load(YamlConfig.loadOrCreateFile(resultFileName, defaultConfigurationResource, plugin));
        return config;
    }

    public static YamlConfiguration loadOrCreate(File file) throws IOException, InvalidConfigurationException {
        YamlConfiguration config = new YamlConfiguration();
        config.load(file);
        return config;
    }

    public static YamlConfiguration loadOrCreate(String fileName, JavaPlugin plugin) throws IOException, InvalidConfigurationException {
        return YamlConfig.loadOrCreate(fileName, fileName, plugin);
    }

    public static File loadOrCreateFile(String resultFileName, String defaultConfigurationResource, JavaPlugin plugin) throws IOException {
        File configFile = new File(plugin.getDataFolder(), resultFileName);
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                throw new RuntimeException("Can't create directory for " + resultFileName);
            }
            try (InputStream resource = plugin.getResource(defaultConfigurationResource);){
                Files.copy(resource, configFile.toPath(), new CopyOption[0]);
            }
        }
        return configFile;
    }

    public static File loadOrCreateFile(String fileName, JavaPlugin plugin) throws IOException {
        return YamlConfig.loadOrCreateFile(fileName, fileName, plugin);
    }

    public ConfigurationSection getSection() {
        return this.configurationSection;
    }

    public YamlConfig(ConfigurationSection configurationSection) {
        if (configurationSection == null) {
            throw new NullArgumentException("configurationSection");
        }
        this.configurationSection = configurationSection;
    }

    private <T extends YamlConfig> List<T> getNestedConfigs(IConfigCreator<T> creator, ConfigurationSection section) {
        ArrayList<T> result = new ArrayList<T>();
        for (String key : section.getKeys(false)) {
            try {
                result.add(creator.Create(section.getConfigurationSection(key)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public <T extends YamlConfig> List<T> getList(IConfigCreator<T> creator, String path) {
        List list = this.getSection().getList(path);
        if (list == null) {
            return null;
        }
        MemoryConfiguration tempConfig = new MemoryConfiguration();
        for (int i = 0; i < list.size(); ++i) {
            tempConfig.createSection(Integer.toString(i), (Map)list.get(i));
        }
        return this.getNestedConfigs(creator, (ConfigurationSection)tempConfig);
    }

    public String getString(String path) {
        return this.configurationSection.getString(path);
    }

    public String getString(String path, String def) {
        return this.configurationSection.getString(path, def);
    }

    public String getColoredString(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getString(path));
    }

    public String getColoredString(String path, String def) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getString(path, def));
    }

    public int getInt(String path) {
        return this.configurationSection.getInt(path);
    }

    public int getInt(String path, int def) {
        return this.configurationSection.getInt(path, def);
    }

    public long getLong(String path) {
        return this.configurationSection.getLong(path);
    }

    public long getLong(String path, long def) {
        return this.configurationSection.getLong(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.configurationSection.getBoolean(path, def);
    }

    public ConfigurationSection getSection(String path) {
        ConfigurationSection result = this.configurationSection.getConfigurationSection(path);
        if (result == null) {
            throw new IllegalArgumentException("Unknown path: " + this.getSection().getCurrentPath() + "." + path);
        }
        return result;
    }

    public ConfigurationSection getSection(String path, ConfigurationSection def) {
        ConfigurationSection result = this.configurationSection.getConfigurationSection(path);
        if (result == null) {
            return def;
        }
        return result;
    }

    public List<String> getStringList(String path) {
        String string;
        List stringList = this.configurationSection.getStringList(path);
        if (stringList.isEmpty() && (string = this.getString(path)) != null) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.add(string);
            return strings;
        }
        return stringList;
    }

    public List<String> getColoredStringList(String path) {
        return Text.setColors(this.getStringList(path));
    }

    public boolean isList(String path) {
        return this.getSection().isList(path);
    }

    public MultilineMessage getMultilineMessage(String path) {
        return new MultilineMessage(this.getList(TextComponentConfig::new, path));
    }
}

