/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data.providers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.reosfire.temporarywhitelist.data.IDataProvider;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;

public class YamlDataProvider
implements IDataProvider {
    private final File yamlDataFile;
    private YamlConfiguration yamlDataConfig;

    public YamlDataProvider(File yamlFile) throws IOException, InvalidConfigurationException {
        this.yamlDataFile = yamlFile;
        this.yamlDataConfig = YamlConfig.loadOrCreate(this.yamlDataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadYaml() {
        File file = this.yamlDataFile;
        synchronized (file) {
            try {
                this.yamlDataConfig = YamlConfig.loadOrCreate(this.yamlDataFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while reloading yaml data file", e);
            }
        }
    }

    private ConfigurationSection getPlayersSection() {
        ConfigurationSection playersSection = this.yamlDataConfig.getConfigurationSection("Players");
        if (playersSection == null) {
            playersSection = this.yamlDataConfig.createSection("Players");
        }
        return playersSection;
    }

    private ConfigurationSection getPlayerSection(String player) {
        ConfigurationSection playersSection = this.getPlayersSection();
        ConfigurationSection playerSection = playersSection.getConfigurationSection(player);
        if (playerSection == null) {
            playerSection = playersSection.createSection(player);
        }
        return playerSection;
    }

    public CompletableFuture<Void> update(PlayerData playerData) {
        return CompletableFuture.runAsync(() -> {
            File file = this.yamlDataFile;
            synchronized (file) {
                this.reloadYaml();
                ConfigurationSection playerSection = this.getPlayerSection(playerData.Name);
                playerSection.set("lastStartTime", (Object)playerData.StartTime);
                playerSection.set("permanent", (Object)playerData.Permanent);
                playerSection.set("timeAmount", (Object)playerData.TimeAmount);
                try {
                    this.yamlDataConfig.save(this.yamlDataFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while updating player data for: " + playerData.Name, e);
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> remove(String playerName) {
        return CompletableFuture.runAsync(() -> {
            this.reloadYaml();
            this.getPlayersSection().set(playerName, null);
            File file = this.yamlDataFile;
            synchronized (file) {
                try {
                    this.yamlDataConfig.save(this.yamlDataFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while removing player data about: " + playerName, e);
                }
            }
        });
    }

    @Override
    public PlayerData get(String playerName) {
        this.reloadYaml();
        ConfigurationSection player = this.getPlayersSection().getConfigurationSection(playerName);
        if (player == null) {
            return null;
        }
        return new PlayerData(player);
    }

    @Override
    public List<PlayerData> getAll() {
        this.reloadYaml();
        ArrayList<PlayerData> result = new ArrayList<PlayerData>();
        ConfigurationSection players = this.getPlayersSection();
        for (String player : players.getKeys(false)) {
            result.add(new PlayerData(this.getPlayerSection(player)));
        }
        return result;
    }
}

