/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data.providers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import ru.reosfire.shaded.com.zaxxer.hikari.HikariConfig;
import ru.reosfire.shaded.com.zaxxer.hikari.HikariDataSource;
import ru.reosfire.temporarywhitelist.configuration.Config;
import ru.reosfire.temporarywhitelist.data.IDataProvider;
import ru.reosfire.temporarywhitelist.data.PlayerData;

public class SqlDataProvider
implements IDataProvider {
    private final Config configuration;
    private final DataSource dataSource;

    public SqlDataProvider(Config configuration) throws SQLException {
        this.configuration = configuration;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(configuration.SqlConfiguration.getConnectionString());
        hikariConfig.setUsername(configuration.SqlConfiguration.getUser());
        hikariConfig.setPassword(configuration.SqlConfiguration.getPassword());
        hikariConfig.setPoolName("TWL Hikari pool");
        hikariConfig.setMaxLifetime(configuration.SqlConfiguration.MaxConnectionLifetime);
        this.dataSource = new HikariDataSource(hikariConfig);
        String createTableString = "CREATE TABLE IF NOT EXISTS `" + this.configuration.SqlTable + "` (Player VARCHAR(32) NOT NULL UNIQUE, Permanent BOOLEAN NOT NULL, LastStartTime BIGINT NOT NULL, TimeAmount BIGINT NOT NULL);";
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(createTableString);
        }
    }

    public CompletableFuture<Void> update(PlayerData playerData) {
        return CompletableFuture.runAsync(() -> {
            String setRequest = "INSERT INTO " + this.configuration.SqlTable + " (Player, Permanent, LastStartTime, TimeAmount)VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE Permanent=?, LastStartTime=?, TimeAmount=?;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(setRequest);){
                statement.setString(1, playerData.Name);
                statement.setBoolean(2, playerData.Permanent);
                statement.setLong(3, playerData.StartTime);
                statement.setLong(4, playerData.TimeAmount);
                statement.setBoolean(5, playerData.Permanent);
                statement.setLong(6, playerData.StartTime);
                statement.setLong(7, playerData.TimeAmount);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while updating player data for: " + playerData.Name, e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> remove(String playerName) {
        return CompletableFuture.runAsync(() -> {
            String removeRequest = "DELETE FROM " + this.configuration.SqlTable + " WHERE Player=?;";
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(removeRequest);){
                statement.setString(1, playerName);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while removing player data about: " + playerName, e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public PlayerData get(String playerName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlayerData> getAll() {
        String selectRequest = "SELECT * FROM " + this.configuration.SqlTable + ";";
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<PlayerData> arrayList;
            block22: {
                PreparedStatement statement = connection.prepareStatement(selectRequest);
                try {
                    ArrayList<PlayerData> result = new ArrayList<PlayerData>();
                    try (ResultSet resultSet = statement.executeQuery(selectRequest);){
                        while (resultSet.next()) {
                            result.add(new PlayerData(resultSet));
                        }
                    }
                    arrayList = result;
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting all data");
        }
    }
}

