/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerData {
    public final String Name;
    public final boolean Permanent;
    public final long StartTime;
    public final long TimeAmount;

    public PlayerData(String name, long startTime, long timeAmount, boolean permanent) {
        this.Name = name;
        this.StartTime = startTime;
        this.TimeAmount = timeAmount;
        this.Permanent = permanent;
    }

    public PlayerData(ResultSet resultSet) throws SQLException {
        this.Name = resultSet.getString("Player");
        this.Permanent = resultSet.getBoolean("Permanent");
        this.StartTime = resultSet.getLong("LastStartTime");
        this.TimeAmount = resultSet.getLong("TimeAmount");
    }

    public PlayerData(ConfigurationSection section) {
        this.Name = section.getName();
        this.Permanent = section.getBoolean("permanent");
        this.StartTime = section.getLong("lastStartTime");
        this.TimeAmount = section.getLong("timeAmount");
    }

    public long endTime() {
        return this.StartTime + this.TimeAmount;
    }

    public boolean isTimedOut() {
        return this.endTime() <= Instant.now().getEpochSecond();
    }

    public long timeLeft() {
        return this.endTime() - Instant.now().getEpochSecond();
    }

    public boolean isSame(PlayerData other) {
        if (!this.Name.equals(other.Name)) {
            return false;
        }
        if (this.Permanent && other.Permanent) {
            return true;
        }
        return this.Permanent == other.Permanent && this.timeLeft() == other.timeLeft();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerData)) {
            return false;
        }
        PlayerData that = (PlayerData)o;
        return this.Permanent == that.Permanent && this.TimeAmount == that.TimeAmount && this.StartTime == that.StartTime && this.Name.equals(that.Name);
    }

    public int hashCode() {
        return Objects.hash(this.Name, this.Permanent, this.StartTime, this.TimeAmount);
    }

    public boolean canJoin() {
        return this.Permanent || !this.isTimedOut();
    }
}

