/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands.importTypes;

import org.bukkit.command.CommandSender;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.ImportCommandResultConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.data.providers.YamlDataProvider;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="self-yaml")
public class SelfYamlImportCommand
extends CommandNode {
    private final TemporaryWhiteList plugin;
    private final ImportCommandResultConfig commandResults;
    private final PlayerDatabase database;

    public SelfYamlImportCommand(TemporaryWhiteList pluginInstance) {
        super(pluginInstance.getMessages().NoPermission);
        this.plugin = pluginInstance;
        this.commandResults = pluginInstance.getMessages().CommandResults.Import;
        this.database = pluginInstance.getDatabase();
    }

    @Override
    protected boolean execute(CommandSender sender, String[] args) {
        if (this.sendMessageIf(this.database.getProvider() instanceof YamlDataProvider, this.commandResults.ImportFromSelf, sender, new Replacement[0])) {
            return true;
        }
        if (this.sendMessageIf(args.length != 0, this.commandResults.SelfYamlUsage, sender, new Replacement[0])) {
            return true;
        }
        YamlDataProvider dataExporter = this.plugin.loadYamlData(this.plugin.getConfiguration());
        dataExporter.exportAsyncAndHandle(this.database, this.commandResults, sender);
        this.commandResults.SuccessfullyStarted.Send(sender, new Replacement[0]);
        return true;
    }
}

