/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands.importTypes;

import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.command.CommandSender;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.ImportCommandResultConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.data.exporters.MinecraftDefaultWhitelist;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="minecraft")
public class MinecraftDefaultImportCommand
extends CommandNode {
    private final ImportCommandResultConfig commandResults;
    private final PlayerDatabase database;
    private final TimeConverter timeConverter;

    public MinecraftDefaultImportCommand(TemporaryWhiteList pluginInstance) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.Import;
        this.database = pluginInstance.getDatabase();
        this.timeConverter = pluginInstance.getTimeConverter();
    }

    @Override
    protected boolean execute(CommandSender sender, String[] args) {
        if (this.sendMessageIf(args.length != 2, this.commandResults.MinecraftDefaultUsage, sender, new Replacement[0])) {
            return true;
        }
        AtomicReference defaultTime = new AtomicReference();
        if (!this.tryParse(this.timeConverter::parseTime, args[0], defaultTime)) {
            this.commandResults.IncorrectTime.Send(sender, new Replacement[0]);
            return true;
        }
        AtomicReference defaultPermanent = new AtomicReference();
        if (!this.tryParse(Boolean::parseBoolean, args[1], defaultPermanent)) {
            this.commandResults.IncorrectPermanent.Send(sender, new Replacement[0]);
            return true;
        }
        MinecraftDefaultWhitelist dataExporter = new MinecraftDefaultWhitelist((Long)defaultTime.get(), (Boolean)defaultPermanent.get());
        dataExporter.exportAsyncAndHandle(this.database, this.commandResults, sender);
        this.commandResults.SuccessfullyStarted.Send(sender, new Replacement[0]);
        return true;
    }
}

