/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.RemoveCommandResultsConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="remove")
@CommandPermission(value="TemporaryWhitelist.Administrate.Remove")
@ExecuteAsync
public class RemoveCommand
extends CommandNode {
    private final RemoveCommandResultsConfig commandResults;
    private final PlayerDatabase database;
    private final boolean forceSync;

    public RemoveCommand(TemporaryWhiteList pluginInstance, boolean forceSync) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.Remove;
        this.database = pluginInstance.getDatabase();
        this.forceSync = forceSync;
    }

    public RemoveCommand(TemporaryWhiteList pluginInstance) {
        this(pluginInstance, false);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        block6: {
            if (this.sendMessageIf(args.length != 1, this.commandResults.Usage, sender, new Replacement[0])) {
                return true;
            }
            Replacement playerReplacement = new Replacement("{player}", args[0]);
            if (this.forceSync) {
                try {
                    boolean changed2 = this.database.remove(args[0]).join();
                    if (!changed2) {
                        this.commandResults.NothingChanged.Send(sender, playerReplacement);
                        break block6;
                    }
                    this.commandResults.Success.Send(sender, playerReplacement);
                }
                catch (Exception e) {
                    this.commandResults.Error.Send(sender, playerReplacement);
                    e.printStackTrace();
                }
            } else {
                this.database.remove(args[0]).whenComplete((changed, exception) -> {
                    if (!changed.booleanValue()) {
                        this.commandResults.NothingChanged.Send(sender, playerReplacement);
                    } else if (exception == null) {
                        this.commandResults.Success.Send(sender, playerReplacement);
                    } else {
                        this.commandResults.Error.Send(sender, playerReplacement);
                        exception.printStackTrace();
                    }
                });
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return this.database.allList().stream().map(e -> e.Name).filter(e -> e.startsWith(args[0])).collect(Collectors.toList());
        }
        return super.onTabComplete(sender, command, alias, args);
    }

    @Override
    public boolean isAsync() {
        if (this.forceSync) {
            return false;
        }
        return super.isAsync();
    }
}

