/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.CheckCommandResultsConfig;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="check")
@CommandPermission(value="TemporaryWhitelist.CheckSelf")
@ExecuteAsync
public class CheckCommand
extends CommandNode {
    private final CheckCommandResultsConfig commandResults;
    private final PlayerDatabase database;
    private final TimeConverter timeconverter;
    private final boolean forceSync;

    public CheckCommand(TemporaryWhiteList pluginInstance, boolean forceSync) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.Check;
        this.database = pluginInstance.getDatabase();
        this.timeconverter = pluginInstance.getTimeConverter();
        this.forceSync = forceSync;
    }

    public CheckCommand(TemporaryWhiteList pluginInstance) {
        this(pluginInstance, false);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            if (sender instanceof Player) {
                this.sendInfo(sender, sender.getName());
            } else {
                this.commandResults.ForPlayerOnly.Send(sender, new Replacement[0]);
            }
        } else if (args.length == 1) {
            if (!sender.hasPermission("TemporaryWhitelist.Administrate.CheckOther")) {
                this.noPermissionAction(sender);
            } else {
                this.sendInfo(sender, args[0]);
            }
        } else {
            this.commandResults.Usage.Send(sender, new Replacement[0]);
        }
        return true;
    }

    private void sendInfo(CommandSender to, String about) {
        PlayerData playerData = this.database.getPlayerData(about);
        if (playerData == null) {
            this.commandResults.InfoNotFound.Send(to, new Replacement[0]);
            return;
        }
        Replacement[] replacements = new Replacement[]{new Replacement("{player}", about), new Replacement("{time_left}", this.timeconverter.durationToString(Math.max(playerData.timeLeft(), 0L))), new Replacement("{started}", this.timeconverter.dateTimeToString(playerData.StartTime)), new Replacement("{will_end}", this.timeconverter.dateTimeToString(playerData.endTime())), new Replacement("{permanent}", playerData.Permanent ? this.commandResults.PermanentTrue : this.commandResults.PermanentFalse)};
        this.commandResults.Format.Send(to, replacements);
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!sender.hasPermission("TemporaryWhitelist.Administrate.CheckOther")) {
            return super.onTabComplete(sender, command, alias, args);
        }
        if (args.length == 1) {
            return this.database.allList().stream().map(e -> e.Name).filter(e -> e.startsWith(args[0])).collect(Collectors.toList());
        }
        return super.onTabComplete(sender, command, alias, args);
    }

    @Override
    public boolean isAsync() {
        if (this.forceSync) {
            return false;
        }
        return super.isAsync();
    }
}

