/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.reosfire.temporarywhitelist.EventsListener;
import ru.reosfire.temporarywhitelist.OnlinePlayersKicker;
import ru.reosfire.temporarywhitelist.PlaceholdersExpansion;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.UpdateChecker;
import ru.reosfire.temporarywhitelist.bstats.bukkit.Metrics;
import ru.reosfire.temporarywhitelist.bstats.charts.SimplePie;
import ru.reosfire.temporarywhitelist.bstats.charts.SingleLineChart;
import ru.reosfire.temporarywhitelist.commands.TwlCommand;
import ru.reosfire.temporarywhitelist.commands.TwlSyncCommand;
import ru.reosfire.temporarywhitelist.configuration.Config;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.data.IDataProvider;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.data.providers.SqlDataProvider;
import ru.reosfire.temporarywhitelist.data.providers.YamlDataProvider;
import ru.reosfire.temporarywhitelist.lib.text.Text;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;
import ru.reosfire.temporarywhitelist.loaders.LocalizationsLoader;

public final class TemporaryWhiteList
extends JavaPlugin {
    private boolean loaded;
    private boolean enabled;
    private Config configuration;
    private PlayerDatabase database;
    private MessagesConfig messages;
    private PlaceholdersExpansion placeholdersExpansion;
    private TimeConverter timeConverter;
    private OnlinePlayersKicker onlinePlayersKicker;

    public Config getConfiguration() {
        return this.configuration;
    }

    public MessagesConfig getMessages() {
        return this.messages;
    }

    public PlayerDatabase getDatabase() {
        return this.database;
    }

    public TimeConverter getTimeConverter() {
        return this.timeConverter;
    }

    public boolean isWhiteListEnabled() {
        return this.enabled;
    }

    public void onEnable() {
        this.load();
        Metrics metrics = new Metrics(this, 14858);
        metrics.addCustomChart(new SingleLineChart("whitelisted_players", () -> this.database.allList().size()));
        metrics.addCustomChart(new SimplePie("whitelisted_players_per_server", () -> Integer.toString(this.database.allList().size())));
        metrics.addCustomChart(new SimplePie("data_provider", () -> this.configuration.DataProvider));
        UpdateChecker updateChecker = new UpdateChecker(this, 99914);
        updateChecker.getVersion(version -> {
            if (version.equalsIgnoreCase(this.getDescription().getVersion())) {
                this.getLogger().info("Plugin is up to date. Please rate it: https://www.spigotmc.org/resources/temporarywhitelist.99914");
            } else {
                this.getLogger().info("There is a new version (" + version + ") available: https://www.spigotmc.org/resources/temporarywhitelist.99914");
            }
        });
    }

    public void load() {
        if (this.loaded) {
            this.unload();
        }
        this.getLogger().info("Loading configurations...");
        this.configuration = this.loadConfiguration();
        this.getLogger().info("Loading messages...");
        LocalizationsLoader localizationsLoader = new LocalizationsLoader(this);
        localizationsLoader.copyDefaultTranslations();
        this.messages = localizationsLoader.loadMessages();
        this.timeConverter = new TimeConverter(this.configuration);
        this.getLogger().info("Loading data...");
        this.database = this.loadDatabase(this.configuration);
        this.getLogger().info("Loading commands...");
        TwlCommand commands = new TwlCommand(this);
        commands.register(Objects.requireNonNull(this.getCommand("twl")));
        TwlSyncCommand syncCommands = new TwlSyncCommand(this);
        syncCommands.register(Objects.requireNonNull(this.getCommand("twl-sync")));
        this.getLogger().info("Loading placeholders...");
        Plugin placeholderAPI = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (placeholderAPI == null) {
            this.getLogger().warning("Placeholder api plugin not found");
        } else {
            this.placeholdersExpansion = new PlaceholdersExpansion(this.messages, this.database, this.timeConverter, this);
            this.placeholdersExpansion.register();
            Text.placeholderApiEnabled = true;
        }
        this.getLogger().info("Loading events handler...");
        EventsListener eventsListener = new EventsListener(this.messages, this.database, this);
        this.getServer().getPluginManager().registerEvents((Listener)eventsListener, (Plugin)this);
        this.onlinePlayersKicker = new OnlinePlayersKicker(this);
        if (this.getEnabledInFile()) {
            this.getLogger().info("Enabling...");
            this.enable();
        }
        this.loaded = true;
        this.getLogger().info("Loaded");
    }

    private void unload() {
        HandlerList.unregisterAll((Plugin)this);
        if (this.placeholdersExpansion != null) {
            this.placeholdersExpansion.unregister();
        }
    }

    private Config loadConfiguration() {
        try {
            return new Config((ConfigurationSection)YamlConfig.loadOrCreate("config.yml", this));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while loading config!");
        }
    }

    private PlayerDatabase loadDatabase(Config config) {
        IDataProvider dataProvider;
        if (config.DataProvider.equals("yaml")) {
            dataProvider = this.loadYamlData(config);
        } else if (config.DataProvider.equals("mysql")) {
            try {
                dataProvider = new SqlDataProvider(config);
            }
            catch (Exception e) {
                e.printStackTrace();
                Bukkit.getLogger().warning("Can't connect to mysql data base! This plugin will use yaml data storing");
                dataProvider = this.loadYamlData(config);
            }
        } else {
            throw new RuntimeException("cannot load data provider of type: " + config.DataProvider);
        }
        return new PlayerDatabase(dataProvider, config.RefreshAfter, config.IgnoreCase);
    }

    public YamlDataProvider loadYamlData(Config config) {
        try {
            return new YamlDataProvider(YamlConfig.loadOrCreateFile(config.DataFile, this));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while loading yaml database!");
        }
    }

    public SqlDataProvider loadSqlData(Config config) {
        try {
            return new SqlDataProvider(config);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while loading sql database!");
        }
    }

    public boolean enable() {
        if (this.enabled) {
            return false;
        }
        this.onlinePlayersKicker.start();
        this.setEnabledInFile(true);
        this.enabled = true;
        return true;
    }

    public boolean disable() {
        if (!this.enabled) {
            return false;
        }
        this.onlinePlayersKicker.stop();
        this.setEnabledInFile(false);
        this.enabled = false;
        return true;
    }

    private void setEnabledInFile(boolean enabled) {
        File configFile = new File(this.getDataFolder(), "enabled.txt");
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(configFile);
                 BufferedWriter writer = new BufferedWriter(fileWriter);){
                writer.write(enabled ? "true" : "false");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while setting enabled in file", e);
        }
        this.enabled = enabled;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean getEnabledInFile() {
        try {
            File configFile = new File(this.getDataFolder(), "enabled.txt");
            if (!configFile.exists()) {
                this.setEnabledInFile(true);
                return true;
            }
            try (FileReader fileReader = new FileReader(configFile);){
                boolean bl;
                try (BufferedReader reader = new BufferedReader(fileReader);){
                    bl = reader.readLine().equals("true");
                }
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }
}

