/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;

public class PlaceholdersExpansion
extends PlaceholderExpansion {
    private final MessagesConfig messages;
    private final PlayerDatabase database;
    private final TimeConverter timeConverter;
    private final TemporaryWhiteList pluginInstance;

    public PlaceholdersExpansion(MessagesConfig messages, PlayerDatabase database, TimeConverter timeConverter, TemporaryWhiteList pluginInstance) {
        this.messages = messages;
        this.database = database;
        this.timeConverter = timeConverter;
        this.pluginInstance = pluginInstance;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.pluginInstance.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "twl";
    }

    @NotNull
    public String getVersion() {
        return this.pluginInstance.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.equals("plugin_status")) {
            return this.pluginInstance.isWhiteListEnabled() ? this.messages.WhiteListEnabledStatus : this.messages.WhiteListDisabledStatus;
        }
        if (player == null) {
            return "";
        }
        PlayerData playerData = this.database.getPlayerData(player.getName());
        if (playerData == null) {
            return this.messages.PlayerStatuses.Undefined;
        }
        if (params.equals("player_status")) {
            if (playerData.Permanent) {
                return this.messages.PlayerStatuses.NeverEnd;
            }
            long timeLeft = playerData.timeLeft();
            if (timeLeft < 0L) {
                return this.messages.PlayerStatuses.Ended;
            }
            return this.timeConverter.durationToString(timeLeft);
        }
        if (params.equals("start_time")) {
            return this.timeConverter.dateTimeToString(playerData.StartTime);
        }
        if (params.equals("left_time")) {
            return this.timeConverter.durationToString(Math.max(playerData.timeLeft(), 0L));
        }
        if (params.equals("end_time")) {
            return this.timeConverter.dateTimeToString(playerData.endTime());
        }
        if (params.equals("permanent")) {
            return Boolean.toString(playerData.Permanent);
        }
        return super.onRequest(player, params);
    }
}

