/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.Config;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;
import ru.reosfire.temporarywhitelist.lib.text.Text;

public class OnlinePlayersKicker {
    private final TemporaryWhiteList pluginInstance;
    private final Config configuration;
    private final PlayerDatabase database;
    private final MessagesConfig messages;
    private BukkitTask checkerTask;
    private BukkitTask kickerTask;
    private final ConcurrentLinkedQueue<UUID> toKick = new ConcurrentLinkedQueue();

    public OnlinePlayersKicker(TemporaryWhiteList pluginInstance) {
        this.pluginInstance = pluginInstance;
        this.configuration = pluginInstance.getConfiguration();
        this.database = pluginInstance.getDatabase();
        this.messages = pluginInstance.getMessages();
    }

    public void start() {
        this.toKick.clear();
        this.runCheckerTask();
        this.runKickerTask();
    }

    public void stop() {
        if (this.checkerTask != null) {
            this.checkerTask.cancel();
        }
        if (this.kickerTask != null) {
            this.kickerTask.cancel();
        }
        this.toKick.clear();
    }

    private void runCheckerTask() {
        this.checkerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.pluginInstance, () -> {
            ArrayList<PlayerInfo> potentialKickPlayersNames = new ArrayList<PlayerInfo>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.isOp() || player.hasPermission("TemporaryWhitelist.Bypass")) continue;
                potentialKickPlayersNames.add(new PlayerInfo(player));
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.pluginInstance, () -> {
                for (PlayerInfo player : potentialKickPlayersNames) {
                    if (this.database.canJoin(player.name)) continue;
                    this.toKick.add(player.uuid);
                }
            });
        }, 0L, (long)this.configuration.SubscriptionEndCheckTicks);
    }

    private void runKickerTask() {
        this.kickerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.pluginInstance, () -> {
            while (!this.toKick.isEmpty()) {
                Player player = Bukkit.getPlayer((UUID)this.toKick.poll());
                if (!player.isOnline()) continue;
                player.kickPlayer(String.join((CharSequence)"\n", Text.colorize((OfflinePlayer)player, this.messages.Kick.WhilePlaying, new Replacement[0])));
            }
        }, (long)(this.configuration.SubscriptionEndCheckTicks / 2), (long)this.configuration.SubscriptionEndCheckTicks);
    }

    private static class PlayerInfo {
        private final String name;
        private final UUID uuid;

        private PlayerInfo(Player player) {
            this.name = player.getName();
            this.uuid = player.getUniqueId();
        }
    }
}

