/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist;

import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;
import ru.reosfire.temporarywhitelist.lib.text.Text;

public class EventsListener
implements Listener {
    private final MessagesConfig messages;
    private final PlayerDatabase database;
    private final TemporaryWhiteList pluginInstance;
    private final HashSet<UUID> bypassedByPreLogin = new HashSet();

    public EventsListener(MessagesConfig messages, PlayerDatabase database, TemporaryWhiteList pluginInstance) {
        this.messages = messages;
        this.database = database;
        this.pluginInstance = pluginInstance;
    }

    @EventHandler
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        if (!this.pluginInstance.isWhiteListEnabled()) {
            return;
        }
        if (this.database.canJoin(event.getName())) {
            this.bypassedByPreLogin.add(event.getUniqueId());
            return;
        }
        if (Bukkit.getOfflinePlayer((UUID)event.getUniqueId()).isOp()) {
            this.bypassedByPreLogin.add(event.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLogin(PlayerLoginEvent event) {
        if (!this.pluginInstance.isWhiteListEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.bypassedByPreLogin.remove(player.getUniqueId())) {
            return;
        }
        if (player.hasPermission("TemporaryWhitelist.Bypass")) {
            return;
        }
        String message = String.join((CharSequence)"\n", Text.colorize((OfflinePlayer)player, this.messages.Kick.Connecting, new Replacement[0]));
        event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, message);
    }
}

