/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.loaders;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.bukkit.configuration.ConfigurationSection;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.Config;
import ru.reosfire.temporarywhitelist.configuration.localization.MessagesConfig;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;

public class LocalizationsLoader {
    private final TemporaryWhiteList plugin;
    private final Config config;

    public LocalizationsLoader(TemporaryWhiteList pluginInstance) {
        this.plugin = pluginInstance;
        this.config = this.plugin.getConfiguration();
    }

    public void copyDefaultTranslations() {
        String[] translationsResources = new String[]{"en.yml", "ru.yml"};
        try {
            File translationsDirectory = new File(this.plugin.getDataFolder(), "./translations/");
            translationsDirectory.mkdir();
            for (String translationsResource : translationsResources) {
                File translationFile = new File(translationsDirectory, translationsResource);
                if (translationFile.exists()) continue;
                InputStream resource = this.plugin.getResource("translations/" + translationsResource);
                byte[] buffer = new byte[resource.available()];
                resource.read(buffer);
                FileOutputStream fileOutputStream = new FileOutputStream(translationFile);
                fileOutputStream.write(buffer);
                fileOutputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MessagesConfig loadMessages() {
        try {
            return new MessagesConfig((ConfigurationSection)YamlConfig.loadOrCreate("translations/" + this.config.Translation, this.plugin));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Can't load translation file", e);
        }
    }
}

