/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.lib.yaml.common.sql;

import org.bukkit.configuration.ConfigurationSection;
import ru.reosfire.temporarywhitelist.lib.sql.ISqlConfiguration;
import ru.reosfire.temporarywhitelist.lib.sql.SqlRequirementsNotSatisfiedException;
import ru.reosfire.temporarywhitelist.lib.yaml.YamlConfig;

public class MysqlConfiguration
extends YamlConfig
implements ISqlConfiguration {
    public final String Ip = this.getString("Ip");
    public final String User;
    public final String Password;
    public final String Database;
    public final boolean UseSsl;
    public final boolean UseUnicode;
    public final boolean AutoReconnect;
    public final boolean FailOverReadOnly;
    public final int Port = this.getInt("Port", 3306);
    public final int MaxReconnects;
    public final long MaxConnectionLifetime;

    public MysqlConfiguration(ConfigurationSection configurationSection) {
        super(configurationSection);
        this.User = this.getString("User");
        this.Password = this.getString("Password");
        this.Database = this.getString("Database");
        this.UseSsl = this.getBoolean("UseSsl", false);
        this.UseUnicode = this.getBoolean("UseUnicode", true);
        this.AutoReconnect = this.getBoolean("AutoReconnect", true);
        this.FailOverReadOnly = this.getBoolean("FailOverReadOnly", false);
        this.MaxReconnects = this.getInt("MaxReconnects", 2);
        this.MaxConnectionLifetime = this.getLong("MaxConnectionLifetime", 550000L);
    }

    @Override
    public String getUser() {
        return this.User;
    }

    @Override
    public String getPassword() {
        return this.Password;
    }

    @Override
    public String getConnectionString() {
        return "jdbc:mysql://" + this.Ip + ":" + this.Port + "/" + this.Database + "?useSSL=" + (this.UseSsl ? "true" : "false") + "&useUnicode=" + (this.UseUnicode ? "true" : "false") + "&autoReconnect=" + (this.AutoReconnect ? "true" : "false") + "&failOverReadOnly=" + (this.FailOverReadOnly ? "true" : "false") + "&maxReconnects=" + this.MaxReconnects;
    }

    @Override
    public long getMaxConnectionLifetime() {
        return this.MaxConnectionLifetime;
    }

    @Override
    public void CheckRequirements() throws SqlRequirementsNotSatisfiedException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new SqlRequirementsNotSatisfiedException(e);
        }
    }
}

