/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.lib.commands;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import ru.reosfire.temporarywhitelist.lib.commands.ArgsCount;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;
import ru.reosfire.temporarywhitelist.lib.yaml.common.text.MultilineMessage;

public abstract class CommandNode
implements CommandExecutor,
TabCompleter {
    private final String noPermissionMessage;
    private List<CommandNode> children = null;

    public CommandNode(String noPermission) {
        Class<?>[] declaredClasses;
        this.noPermissionMessage = noPermission;
        Class<?> currentExtendedClass = this.getClass();
        for (Class<?> declaredClass : declaredClasses = currentExtendedClass.getDeclaredClasses()) {
            try {
                Constructor<?> constructor = declaredClass.getDeclaredConstructor(this.getClass());
                Object innerInstance = constructor.newInstance(this);
                if (!(innerInstance instanceof CommandNode)) continue;
                CommandNode commandNode = (CommandNode)innerInstance;
                this.addChildren(commandNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String requiredPermission = this.getPermission();
        if (!(sender instanceof ConsoleCommandSender) && requiredPermission != null && !sender.hasPermission(requiredPermission)) {
            this.noPermissionAction(sender);
            return true;
        }
        boolean executorFound = false;
        boolean lastExecutionResult = false;
        if (this.children != null && args.length > 0) {
            for (CommandNode child : this.children) {
                if (!child.getName().equals(args[0])) continue;
                String[] newArgs = new String[args.length - 1];
                System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                command.setName(args[0]);
                lastExecutionResult = child.onCommand(sender, command, args[0], newArgs);
                executorFound = true;
            }
        }
        if (!(executorFound || this.getArgsCount() >= 0 && this.getArgsCount() != args.length)) {
            return this.execute(sender, args, this.isAsync());
        }
        return lastExecutionResult;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        String requiredPermission = this.getPermission();
        if (!(sender instanceof ConsoleCommandSender || requiredPermission == null || sender.hasPermission(requiredPermission) || sender.isOp())) {
            return new ArrayList<String>();
        }
        if (this.children == null) {
            return this.completeTab(args);
        }
        for (CommandNode child : this.children) {
            if (!child.getName().equals(args[0])) continue;
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            return child.onTabComplete(sender, command, alias, newArgs);
        }
        if (args.length == 1) {
            ArrayList<String> result = new ArrayList<String>();
            for (CommandNode child : this.children) {
                if (!child.getName().startsWith(args[0]) || child.getPermission() != null && !sender.hasPermission(child.getPermission())) continue;
                result.add(child.getName());
            }
            return result;
        }
        return new ArrayList<String>();
    }

    public final void addChildren(CommandNode child) {
        if (this.children == null) {
            this.children = new ArrayList<CommandNode>();
        }
        this.children.add(child);
    }

    private boolean execute(CommandSender sender, String[] args, boolean async) {
        if (async) {
            CompletableFuture.runAsync(() -> this.execute(sender, args)).handle((res, ex) -> {
                if (ex != null) {
                    sender.sendMessage(ChatColor.RED + "Unhandled exception while executing async command. More info in console");
                    ex.printStackTrace();
                }
                return null;
            });
            return true;
        }
        return this.execute(sender, args);
    }

    protected abstract boolean execute(CommandSender var1, String[] var2);

    protected List<String> completeTab(String[] args) {
        return Collections.emptyList();
    }

    protected String getName() {
        CommandName annotation = this.getClass().getAnnotation(CommandName.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    protected String getPermission() {
        CommandPermission annotation = this.getClass().getAnnotation(CommandPermission.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    protected boolean isAsync() {
        ExecuteAsync annotation = this.getClass().getAnnotation(ExecuteAsync.class);
        return annotation != null;
    }

    private int getArgsCount() {
        ArgsCount annotation = this.getClass().getAnnotation(ArgsCount.class);
        if (annotation == null) {
            return -1;
        }
        return annotation.value();
    }

    protected void noPermissionAction(CommandSender sender) {
        sender.sendMessage(this.noPermissionMessage);
    }

    public final void register(PluginCommand command) {
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    protected final <T> boolean tryParse(Function<String, T> parser, String s, AtomicReference<T> container) {
        try {
            container.set(parser.apply(s));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final boolean sendMessageIf(boolean send, MultilineMessage message, CommandSender sender, Replacement ... replacements) {
        if (send) {
            message.Send(sender, replacements);
        }
        return send;
    }

    protected final List<String> getStartingWith(List<String> input, String start) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : input) {
            if (!s.startsWith(start)) continue;
            result.add(start);
        }
        return result;
    }
}

