/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data.providers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.sql.DataSource;
import ru.reosfire.shaded.com.zaxxer.hikari.HikariConfig;
import ru.reosfire.shaded.com.zaxxer.hikari.HikariDataSource;
import ru.reosfire.temporarywhitelist.configuration.Config;
import ru.reosfire.temporarywhitelist.data.IDataProvider;
import ru.reosfire.temporarywhitelist.data.PlayerData;

public class SqlDataProvider
implements IDataProvider {
    private final Config configuration;
    private final DataSource dataSource;

    public SqlDataProvider(Config configuration) throws SQLException {
        this.configuration = configuration;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(configuration.SqlConfiguration.getConnectionString());
        hikariConfig.setUsername(configuration.SqlConfiguration.getUser());
        hikariConfig.setPassword(configuration.SqlConfiguration.getPassword());
        hikariConfig.setPoolName("TWL Hikari pool");
        hikariConfig.setMaxLifetime(configuration.SqlConfiguration.MaxConnectionLifetime);
        this.dataSource = new HikariDataSource(hikariConfig);
        String createTableString = "CREATE TABLE IF NOT EXISTS `" + this.configuration.SqlTable + "` (Player VARCHAR(32) NOT NULL UNIQUE, Permanent BOOLEAN NOT NULL, LastStartTime BIGINT NOT NULL, TimeAmount BIGINT NOT NULL);";
        try (Statement statement = this.dataSource.getConnection().createStatement();){
            statement.executeUpdate(createTableString);
        }
    }

    public CompletableFuture<Void> update(PlayerData playerData) {
        return CompletableFuture.runAsync(() -> {
            String setRequest = "INSERT INTO " + this.configuration.SqlTable + " (Player, Permanent, LastStartTime, TimeAmount)VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE Permanent=?, LastStartTime=?, TimeAmount=?;";
            try (PreparedStatement statement = this.dataSource.getConnection().prepareStatement(setRequest);){
                statement.setString(1, playerData.Name);
                statement.setBoolean(2, playerData.Permanent);
                statement.setLong(3, playerData.StartTime);
                statement.setLong(4, playerData.TimeAmount);
                statement.setBoolean(5, playerData.Permanent);
                statement.setLong(6, playerData.StartTime);
                statement.setLong(7, playerData.TimeAmount);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while updating player data for: " + playerData.Name, e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> remove(String playerName) {
        return CompletableFuture.runAsync(() -> {
            String removeRequest = "DELETE FROM " + this.configuration.SqlTable + " WHERE Player=?;";
            try (PreparedStatement statement = this.dataSource.getConnection().prepareStatement(removeRequest);){
                statement.setString(1, playerName);
                statement.executeUpdate();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while removing player data about: " + playerName, e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerData get(String playerName) {
        String selectRequest = "SELECT * FROM " + this.configuration.SqlTable + " WHERE Player=?;";
        try (PreparedStatement statement = this.dataSource.getConnection().prepareStatement(selectRequest);){
            statement.setString(1, playerName);
            ResultSet player = statement.executeQuery();
            if (!player.next()) {
                PlayerData playerData2 = null;
                return playerData2;
            }
            PlayerData playerData = new PlayerData(player);
            return playerData;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlayerData> getAll() {
        String selectRequest = "SELECT * FROM " + this.configuration.SqlTable + ";";
        try (Statement statement = this.dataSource.getConnection().createStatement();){
            ArrayList<PlayerData> result = new ArrayList<PlayerData>();
            ResultSet resultSet = statement.executeQuery(selectRequest);
            while (resultSet.next()) {
                result.add(new PlayerData(resultSet));
            }
            ArrayList<PlayerData> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting all data");
        }
    }
}

