/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data.exporters;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.ImportCommandResultConfig;
import ru.reosfire.temporarywhitelist.data.ExportResult;
import ru.reosfire.temporarywhitelist.data.IUpdatable;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

public interface IDataExporter {
    public List<PlayerData> getAll();

    default public ExportResult exportTo(IUpdatable updatable) {
        List<PlayerData> players = this.getAll();
        ExportResult exportResult = new ExportResult(players);
        CompletableFuture[] updates = new CompletableFuture[players.size()];
        for (int i = 0; i < players.size(); ++i) {
            PlayerData playerData = players.get(i);
            updates[i] = updatable.update(playerData);
            updates[i].handle((res, ex) -> {
                if (ex == null) {
                    exportResult.WithoutError.add(playerData);
                } else {
                    ex.printStackTrace();
                }
                return null;
            });
        }
        CompletableFuture.allOf(updates).join();
        return exportResult;
    }

    default public CompletableFuture<ExportResult> exportToAsync(IUpdatable provider) {
        return CompletableFuture.supplyAsync(() -> this.exportTo(provider));
    }

    default public void ExportAndHandle(IUpdatable updatable, ImportCommandResultConfig commandResults, CommandSender sender) {
        try {
            ExportResult exportResult = this.exportTo(updatable);
            commandResults.Success.Send(sender, exportResult.getReplacements());
        }
        catch (Exception e) {
            commandResults.Error.Send(sender, new Replacement[0]);
            e.printStackTrace();
        }
    }

    default public void exportAsyncAndHandle(IUpdatable updatable, ImportCommandResultConfig commandResults, CommandSender sender) {
        this.exportToAsync(updatable).handle((res, ex) -> {
            if (ex == null) {
                commandResults.Success.Send(sender, res.getReplacements());
            } else {
                commandResults.Error.Send(sender, new Replacement[0]);
                ex.printStackTrace();
            }
            return null;
        });
    }
}

