/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data.exporters;

import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.management.ReflectionException;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.data.exporters.IDataExporter;

public class EasyWhitelist
implements IDataExporter {
    private final long defaultTimeAmount;
    private final boolean defaultPermanent;
    private final Method getWhiteListsMethod;
    private final Object WLStorage;

    public EasyWhitelist(long defaultTimeAmount, boolean defaultPermanent) throws ReflectionException {
        this.defaultTimeAmount = defaultTimeAmount;
        this.defaultPermanent = defaultPermanent;
        try {
            Class<?> easyWhiteListClass = Class.forName("com.gmail.jyckosianjaya.easywhitelist.EasyWhiteList");
            Method getInstanceMethod = easyWhiteListClass.getMethod("getInstance", new Class[0]);
            Method getStorageMethod = easyWhiteListClass.getMethod("getStorage", new Class[0]);
            Object easyWhiteListInstance = getInstanceMethod.invoke(null, new Object[0]);
            this.WLStorage = getStorageMethod.invoke(easyWhiteListInstance, new Object[0]);
            Class<?> WLStorageClass = Class.forName("com.gmail.jyckosianjaya.easywhitelist.WLStorage");
            this.getWhiteListsMethod = WLStorageClass.getMethod("getWhiteLists", new Class[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Can't load easy-whitelist plugin");
        }
    }

    @Override
    public List<PlayerData> getAll() {
        long currentTime = Instant.now().getEpochSecond();
        ArrayList<PlayerData> result = new ArrayList<PlayerData>();
        try {
            for (Object player : (ArrayList)this.getWhiteListsMethod.invoke(this.WLStorage, new Object[0])) {
                if (!(player instanceof String)) continue;
                result.add(new PlayerData((String)player, currentTime, this.defaultTimeAmount, this.defaultPermanent));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting data from easy-whitelist", e);
        }
        return result;
    }
}

