/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang.NullArgumentException;
import ru.reosfire.temporarywhitelist.data.IDataProvider;
import ru.reosfire.temporarywhitelist.data.IUpdatable;
import ru.reosfire.temporarywhitelist.data.PlayerData;

public class PlayerDatabase
implements IUpdatable {
    private final IDataProvider provider;
    private final Map<String, PlayerData> playersData = new ConcurrentSkipListMap<String, PlayerData>();
    private final Map<String, Long> lastRefresh = new ConcurrentHashMap<String, Long>();
    private long lastAllRefresh;
    private final long refreshInterval;
    private final boolean ignoreCase;

    public IDataProvider getProvider() {
        return this.provider;
    }

    public PlayerDatabase(IDataProvider provider, long refreshInterval, boolean ignoreCase) {
        this.provider = provider;
        this.refreshInterval = refreshInterval;
        this.ignoreCase = ignoreCase;
        this.loadAll();
    }

    public PlayerData getPlayerData(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        this.tryRefreshPlayer(name);
        return this.playersData.get(name);
    }

    public CompletableFuture<Boolean> update(PlayerData playerData) {
        if (playerData == null) {
            throw new NullArgumentException("playerName");
        }
        String name = playerData.Name;
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        this.tryRefreshPlayer(name);
        PlayerData oldData = this.getPlayerData(name);
        if (oldData != null && oldData.isSame(playerData)) {
            return CompletableFuture.completedFuture(false);
        }
        String finalName = name;
        return this.provider.update(playerData).handle((res, ex) -> {
            if (ex != null) {
                throw new RuntimeException((Throwable)ex);
            }
            this.playersData.put(finalName, playerData);
            return true;
        });
    }

    public boolean canJoin(String name) {
        PlayerData playerData;
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((playerData = this.getPlayerData(name)) == null) {
            return false;
        }
        return playerData.canJoin();
    }

    public CompletableFuture<Boolean> add(String name, long addedTime) {
        boolean permanent;
        long timeAmount;
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        PlayerData playerData = this.getPlayerData(name);
        long startTime = Instant.now().getEpochSecond();
        if (playerData == null) {
            timeAmount = addedTime;
            permanent = false;
        } else {
            timeAmount = playerData.isTimedOut() ? addedTime : playerData.timeLeft() + addedTime;
            permanent = playerData.Permanent;
        }
        return this.update(new PlayerData(name, startTime, timeAmount, permanent));
    }

    public CompletableFuture<Boolean> setPermanent(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        long startTime = Instant.now().getEpochSecond();
        long timeAmount = 0L;
        boolean permanent = true;
        return this.update(new PlayerData(name, startTime, timeAmount, permanent));
    }

    public CompletableFuture<Boolean> set(String name, long time) {
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        long startTime = Instant.now().getEpochSecond();
        boolean permanent = false;
        return this.update(new PlayerData(name, startTime, time, permanent));
    }

    public CompletableFuture<Boolean> remove(String name) {
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        this.tryRefreshPlayer(name);
        if (!this.playersData.containsKey(name)) {
            return CompletableFuture.completedFuture(false);
        }
        String finalName = name;
        return ((CompletableFuture)this.provider.remove(name).thenRun(() -> this.playersData.remove(finalName))).thenApply(res -> true);
    }

    public List<PlayerData> activeList() {
        ArrayList<PlayerData> result = new ArrayList<PlayerData>();
        for (PlayerData playerData : this.allList()) {
            if (!playerData.canJoin()) continue;
            result.add(playerData);
        }
        return result;
    }

    public Collection<PlayerData> allList() {
        this.tryRefreshAll();
        return this.playersData.values();
    }

    private void loadAll() {
        long nowTime = Instant.now().getEpochSecond();
        this.playersData.clear();
        this.lastRefresh.clear();
        for (PlayerData playerData : this.provider.getAll()) {
            String name = playerData.Name;
            if (this.ignoreCase) {
                name = name.toLowerCase(Locale.ROOT);
            }
            this.playersData.put(name, playerData);
            this.lastRefresh.put(name, nowTime);
        }
    }

    private void tryRefreshPlayer(String name) {
        PlayerData actualData;
        long timePassed;
        if (this.refreshInterval < 0L) {
            return;
        }
        long nowTime = Instant.now().getEpochSecond();
        if (this.refreshInterval != 0L && (timePassed = nowTime - this.lastRefresh.getOrDefault(name, 0L)) < this.refreshInterval) {
            return;
        }
        if (this.ignoreCase) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((actualData = this.provider.get(name)) == null) {
            this.playersData.remove(name);
        } else {
            this.playersData.put(name, actualData);
        }
        this.lastRefresh.put(name, nowTime);
    }

    private void tryRefreshAll() {
        long nowTime = Instant.now().getEpochSecond();
        if (nowTime - this.lastAllRefresh < this.refreshInterval) {
            return;
        }
        this.loadAll();
        this.lastAllRefresh = nowTime;
    }
}

