/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.data;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

public class ExportResult {
    public final List<PlayerData> Found;
    public final Set<PlayerData> WithoutError = new HashSet<PlayerData>();
    public final long StartTime;

    public ExportResult(List<PlayerData> found) {
        this.Found = found;
        this.StartTime = Instant.now().toEpochMilli();
    }

    public int withErrorCount() {
        return this.Found.size() - this.WithoutError.size();
    }

    public List<PlayerData> withError() {
        if (this.WithoutError.size() == 0) {
            return this.Found;
        }
        ArrayList<PlayerData> result = new ArrayList<PlayerData>();
        for (PlayerData playerData : this.Found) {
            if (this.WithoutError.contains(playerData)) continue;
            result.add(playerData);
        }
        return result;
    }

    public Replacement[] getReplacements() {
        return new Replacement[]{new Replacement("{found_count}", Integer.toString(this.Found.size())), new Replacement("{with_error_count}", Integer.toString(this.withErrorCount())), new Replacement("{without_error_count}", Integer.toString(this.WithoutError.size())), new Replacement("{found}", ExportResult.playersDataToString(this.Found)), new Replacement("{with_error}", ExportResult.playersDataToString(this.withError())), new Replacement("{without_error}", ExportResult.playersDataToString(this.WithoutError)), new Replacement("{time_elapsed}", ExportResult.timeElapsedToString(this.getElapsed()))};
    }

    public long getElapsed() {
        return Instant.now().toEpochMilli() - this.StartTime;
    }

    private static String playersDataToString(Collection<PlayerData> players) {
        StringBuilder result = new StringBuilder();
        for (PlayerData player : players) {
            result.append(player.Name).append(" ");
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    private static String timeElapsedToString(long ms) {
        long seconds = ms / 1000L;
        long milliSeconds = ms % 1000L;
        return seconds + "s " + milliSeconds + "ms";
    }
}

