/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.SetCommandResultsConfig;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="set")
@CommandPermission(value="TemporaryWhitelist.Administrate.Set")
@ExecuteAsync
public class SetCommand
extends CommandNode {
    private final SetCommandResultsConfig commandResults;
    private final PlayerDatabase database;
    private final TimeConverter timeConverter;
    private final boolean forceSync;

    public SetCommand(TemporaryWhiteList pluginInstance, boolean forceSync) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.Set;
        this.database = pluginInstance.getDatabase();
        this.timeConverter = pluginInstance.getTimeConverter();
        this.forceSync = forceSync;
    }

    public SetCommand(TemporaryWhiteList pluginInstance) {
        this(pluginInstance, false);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        block10: {
            if (this.sendMessageIf(args.length != 2, this.commandResults.Usage, sender, new Replacement[0])) {
                return true;
            }
            Replacement playerReplacement = new Replacement("{player}", args[0]);
            Replacement timeReplacement = new Replacement("{time}", args[1]);
            if (args[1].equals("permanent")) {
                this.database.setPermanent(args[0]).whenComplete((changed, exception) -> this.handleCompletion((boolean)changed, (Throwable)exception, sender, playerReplacement, timeReplacement));
            } else {
                long time;
                try {
                    time = this.timeConverter.parseTime(args[1]);
                }
                catch (Exception e) {
                    this.commandResults.IncorrectTime.Send(sender, new Replacement[0]);
                    return true;
                }
                if (this.forceSync) {
                    try {
                        Boolean changed2 = this.database.set(args[0], time).join();
                        if (!changed2.booleanValue()) {
                            this.commandResults.NothingChanged.Send(sender, playerReplacement, timeReplacement);
                            break block10;
                        }
                        this.commandResults.Success.Send(sender, playerReplacement, timeReplacement);
                    }
                    catch (Exception e) {
                        this.commandResults.Error.Send(sender, playerReplacement, timeReplacement);
                        e.printStackTrace();
                    }
                } else {
                    this.database.set(args[0], time).whenComplete((changed, exception) -> this.handleCompletion((boolean)changed, (Throwable)exception, sender, playerReplacement, timeReplacement));
                }
            }
        }
        return true;
    }

    private void handleCompletion(boolean changed, Throwable exception, CommandSender sender, Replacement ... replacements) {
        if (!changed) {
            this.commandResults.NothingChanged.Send(sender, replacements);
        } else if (exception == null) {
            this.commandResults.Success.Send(sender, replacements);
        } else {
            this.commandResults.Error.Send(sender, replacements);
            exception.printStackTrace();
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return this.database.allList().stream().map(e -> e.Name).filter(e -> e.startsWith(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2 && "permanent".startsWith(args[1])) {
            return Collections.singletonList("permanent");
        }
        return super.onTabComplete(sender, command, alias, args);
    }

    @Override
    public boolean isAsync() {
        if (this.forceSync) {
            return false;
        }
        return super.isAsync();
    }
}

