/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands;

import java.util.List;
import org.bukkit.command.CommandSender;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.ListCommandResultsConfig;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="list")
@CommandPermission(value="TemporaryWhitelist.Administrate.List")
@ExecuteAsync
public class ListCommand
extends CommandNode {
    private final ListCommandResultsConfig commandResults;
    private final PlayerDatabase database;
    private final int pageSize;

    public ListCommand(TemporaryWhiteList pluginInstance) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.List;
        this.database = pluginInstance.getDatabase();
        this.pageSize = pluginInstance.getConfiguration().ListPageSize;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        int pageStart;
        List<PlayerData> players;
        if (this.sendMessageIf(args.length > 1, this.commandResults.Usage, sender, new Replacement[0])) {
            return true;
        }
        int page = 1;
        if (args.length == 1) {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                this.commandResults.IncorrectPage.Send(sender, new Replacement[0]);
                return true;
            }
        }
        if ((players = this.database.activeList()).size() == 0) {
            this.commandResults.ListIsEmpty.Send(sender, new Replacement[0]);
            return true;
        }
        int totalPages = this.ceilDivide(players.size(), this.pageSize);
        if (page < 1 || page > totalPages) {
            this.commandResults.IncorrectPage.Send(sender, new Replacement[0]);
            return true;
        }
        this.commandResults.Header.Send(sender, new Replacement[0]);
        int pageEnd = this.pageSize * page;
        for (int i = pageStart = pageEnd - this.pageSize; i < pageEnd; ++i) {
            if (i < players.size()) {
                this.commandResults.PlayerFormat.Send(sender, new Replacement("{player}", players.get((int)i).Name), new Replacement("{number}", Integer.toString(i + 1)));
                continue;
            }
            sender.sendMessage("");
        }
        int previousPage = Math.max(page - 1, 1);
        int nextPage = Math.min(page + 1, totalPages);
        this.commandResults.PagesSwitch.Send(sender, new Replacement("{previous_page}", Integer.toString(previousPage)), new Replacement("{page}", Integer.toString(page)), new Replacement("{total_pages}", Integer.toString(totalPages)), new Replacement("{next_page}", Integer.toString(nextPage)));
        return true;
    }

    private int ceilDivide(int a, int b) {
        return (a + b - 1) / b;
    }
}

