/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist.commands.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import ru.reosfire.temporarywhitelist.TemporaryWhiteList;
import ru.reosfire.temporarywhitelist.TimeConverter;
import ru.reosfire.temporarywhitelist.configuration.localization.commandResults.AddCommandResultsConfig;
import ru.reosfire.temporarywhitelist.data.PlayerData;
import ru.reosfire.temporarywhitelist.data.PlayerDatabase;
import ru.reosfire.temporarywhitelist.lib.commands.CommandName;
import ru.reosfire.temporarywhitelist.lib.commands.CommandNode;
import ru.reosfire.temporarywhitelist.lib.commands.CommandPermission;
import ru.reosfire.temporarywhitelist.lib.commands.ExecuteAsync;
import ru.reosfire.temporarywhitelist.lib.text.Replacement;

@CommandName(value="add")
@CommandPermission(value="TemporaryWhitelist.Administrate.Add")
@ExecuteAsync
public class AddCommand
extends CommandNode {
    private final AddCommandResultsConfig commandResults;
    private final PlayerDatabase database;
    private final TimeConverter timeConverter;
    private final boolean forceSync;

    public AddCommand(TemporaryWhiteList pluginInstance, boolean forceSync) {
        super(pluginInstance.getMessages().NoPermission);
        this.commandResults = pluginInstance.getMessages().CommandResults.Add;
        this.database = pluginInstance.getDatabase();
        this.timeConverter = pluginInstance.getTimeConverter();
        this.forceSync = forceSync;
    }

    public AddCommand(TemporaryWhiteList pluginInstance) {
        this(pluginInstance, false);
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (this.sendMessageIf(args.length != 2, this.commandResults.Usage, sender, new Replacement[0])) {
            return true;
        }
        Replacement playerReplacement = new Replacement("{player}", args[0]);
        Replacement timeReplacement = new Replacement("{time}", args[1]);
        PlayerData playerData = this.database.getPlayerData(args[0]);
        if (this.sendMessageIf(playerData != null && playerData.Permanent, this.commandResults.AlreadyPermanent, sender, playerReplacement)) {
            return true;
        }
        if (args[1].equals("permanent")) {
            this.database.setPermanent(args[0]).whenComplete((changed, exception) -> this.handleCompletion(sender, (Throwable)exception, playerReplacement, timeReplacement));
        } else {
            AtomicReference time = new AtomicReference();
            if (!this.tryParse(this.timeConverter::parseTime, args[1], time)) {
                this.commandResults.IncorrectTime.Send(sender, new Replacement[0]);
                return true;
            }
            if (this.forceSync) {
                try {
                    this.database.add(args[0], (Long)time.get()).join();
                    this.commandResults.Success.Send(sender, playerReplacement, timeReplacement);
                }
                catch (Exception e) {
                    this.commandResults.Error.Send(sender, playerReplacement, timeReplacement);
                    e.printStackTrace();
                }
            } else {
                this.database.add(args[0], (Long)time.get()).whenComplete((result, exception) -> this.handleCompletion(sender, (Throwable)exception, playerReplacement, timeReplacement));
            }
        }
        return true;
    }

    private void handleCompletion(CommandSender sender, Throwable exception, Replacement ... replacements) {
        if (exception == null) {
            this.commandResults.Success.Send(sender, replacements);
        } else {
            this.commandResults.Error.Send(sender, replacements);
            exception.printStackTrace();
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return this.database.allList().stream().map(e -> e.Name).filter(e -> e.startsWith(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2 && "permanent".startsWith(args[1])) {
            return Collections.singletonList("permanent");
        }
        return super.onTabComplete(sender, command, alias, args);
    }

    @Override
    public boolean isAsync() {
        if (this.forceSync) {
            return false;
        }
        return super.isAsync();
    }
}

