/*
 * Decompiled with CFR 0.152.
 */
package ru.reosfire.temporarywhitelist;

import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import ru.reosfire.temporarywhitelist.configuration.Config;

public class TimeConverter {
    private final Config config;

    public TimeConverter(Config config) {
        this.config = config;
    }

    public String durationToString(long seconds) {
        return DurationFormatUtils.formatDuration((long)(seconds * 1000L), (String)this.config.DurationFormat);
    }

    public String dateTimeToString(long seconds) {
        return DateFormatUtils.format((long)(seconds * 1000L), (String)this.config.DateTimeFormat);
    }

    public long parseTime(String time) {
        String[] timeElements;
        long secondsInYear = 31536000L;
        long secondsInDay = 86400L;
        long secondsInHour = 3600L;
        long secondsInMinute = 60L;
        long result = 0L;
        block14: for (String timeElement : timeElements = time.split(",")) {
            String[] split = timeElement.split(":");
            switch (split[1]) {
                case "s": {
                    result += Long.parseLong(split[0]);
                    continue block14;
                }
                case "m": {
                    result += Long.parseLong(split[0]) * secondsInMinute;
                    continue block14;
                }
                case "h": {
                    result += Long.parseLong(split[0]) * secondsInHour;
                    continue block14;
                }
                case "d": {
                    result += Long.parseLong(split[0]) * secondsInDay;
                    continue block14;
                }
                case "y": {
                    result += Long.parseLong(split[0]) * secondsInYear;
                    continue block14;
                }
                default: {
                    throw new RuntimeException("Invalid time unit");
                }
            }
        }
        return result;
    }
}

