/*
 * Decompiled with CFR 0.152.
 */
package playcraft.dimon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Team;

public class Main
extends JavaPlugin
implements Listener {
    private int version = 2;
    private String scoreboard = "TeamChatPlugin";
    private boolean color = true;
    private int messageDelay = 0;
    private String mTeamChat = "\u00a77[\u00a7aTeam\u00a79Chat\u00a77]\u00a7r ";
    private String globalPrefix = "\u00a77[\u00a7aG\u00a77]\u00a7r ";
    private String teamPrefix = "\u00a77[\u00a79T\u00a77]\u00a7r ";
    private String globalSufix = " \u00a7a\u27a1\u00a7r ";
    private String teamSufix = " \u00a79\u27a1\u00a7r ";
    private String messageGlobal = "\u00a7a\u00a7lGlobal Chat. \u00a7r\u00a7e/team \u00a7f\u00a7omessage \u00a7r- \u00a79To team.";
    private String messageTeam = "\u00a79\u00a7lTeam Chat. \u00a7r\u00a7e/global \u00a7f\u00a7omessage \u00a7r- \u00a7aTo global.";
    private String mDelay = "\u00a77Don't flood! \u00a78Delay ";
    private final Map<String, Long> delays = new ConcurrentHashMap<String, Long>();

    public void onEnable() {
        File cfgFile = new File(this.getDataFolder(), "config.yml");
        if (!cfgFile.exists()) {
            try {
                this.copyFromInputStream(cfgFile, this.getResource("config.yml"));
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, "Failed to write config.yml", ex);
                this.getConfig().options().copyDefaults(true);
                this.saveConfig();
            }
        }
        this.reloadConfigTeamChat();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getLogger().info("[TeamChat] Plugin - Enable");
        if (Bukkit.getScoreboardManager().getMainScoreboard().getObjective(this.scoreboard) != null) {
            Bukkit.getLogger().info("[TeamChat] Objective Allready Created!");
        } else {
            Bukkit.getScoreboardManager().getMainScoreboard().registerNewObjective(this.scoreboard, "dummy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigTeamChat() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        if (this.version != config.getInt("Version", 0)) {
            try {
                File src = new File(this.getDataFolder(), "config.yml");
                File dst = new File(this.getDataFolder(), "backup-" + config.getInt("Version", 0) + ".yml");
                try (FileInputStream is = new FileInputStream(src);
                     FileOutputStream os = new FileOutputStream(dst);){
                    int size;
                    byte[] data = new byte[81920];
                    while ((size = ((InputStream)is).read(data)) >= 0) {
                        ((OutputStream)os).write(data, 0, size);
                    }
                }
                src.delete();
                this.copyFromInputStream(src, this.getResource("config.yml"));
            }
            catch (IOException e) {
                System.out.println("ERROR");
            }
            config.set("Version", (Object)this.version);
            this.reloadConfigTeamChat();
        } else {
            this.scoreboard = config.getString("Scoreboard");
            this.color = config.getBoolean("Color");
            this.messageDelay = config.getInt("Delay");
            this.globalPrefix = config.getString("GlobalPrefix");
            this.teamPrefix = config.getString("TeamPrefix");
            this.globalSufix = config.getString("GlobalSufix");
            this.teamSufix = config.getString("TeamSufix");
            this.messageGlobal = config.getString("MessageGlobal");
            this.messageTeam = config.getString("MessageTeam");
            this.mDelay = config.getString("MessageDelay");
        }
    }

    public void copyFromInputStream(File dst, InputStream is) throws IOException {
        dst.getParentFile().mkdirs();
        dst.createNewFile();
        FileOutputStream out = new FileOutputStream(dst);
        byte[] data = new byte[81920];
        while (true) {
            int amount;
            if ((amount = is.read(data)) < 0) {
                is.close();
                ((OutputStream)out).close();
                return;
            }
            ((OutputStream)out).write(data, 0, amount);
        }
    }

    public void onDisable() {
        Bukkit.getLogger().info("[TeamChat] Plugin - Disable");
    }

    @EventHandler
    public void playerQuitEvent(PlayerQuitEvent quit) {
        this.delays.remove(quit.getPlayer().getName());
    }

    @EventHandler
    public void playerChatEvent(AsyncPlayerChatEvent chat) {
        String getPrefix = "";
        Player player = chat.getPlayer();
        Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
        Set recipients = chat.getRecipients();
        Iterator iterator = recipients.iterator();
        if (team != null) {
            getPrefix = this.color ? team.getPrefix() : "";
            if (player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).getScore() == 1) {
                String message = this.teamPrefix + getPrefix + player.getDisplayName() + team.getSuffix() + this.teamSufix + "%2$s";
                chat.setFormat(message);
                while (iterator.hasNext()) {
                    if (team.hasPlayer((OfflinePlayer)iterator.next())) continue;
                    iterator.remove();
                }
            } else {
                Long i = this.delays.get(player.getName());
                if (this.messageDelay != 0 && i != null && i > System.currentTimeMillis()) {
                    chat.setCancelled(true);
                    Long t = (this.delays.get(player.getName()) - System.currentTimeMillis()) / 1000L;
                    player.sendMessage(this.mTeamChat + this.mDelay + t + "s.");
                } else {
                    String message = this.globalPrefix + getPrefix + player.getDisplayName() + team.getSuffix() + this.globalSufix + "%2$s";
                    chat.setFormat(message);
                    if (this.messageDelay > 0 && !player.hasPermission("teamchat.player.delay")) {
                        this.delays.put(player.getName(), System.currentTimeMillis() + (long)(this.messageDelay * 1000));
                    }
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isPlayer = sender instanceof Player;
        String mChat = "chat";
        if (sender.hasPermission("teamchat.admin.reload") && args.length == 1 && command.getName().equals(mChat) && args[0].equals("reload")) {
            File cfgFile = new File(this.getDataFolder(), "config.yml");
            if (!cfgFile.exists()) {
                sender.sendMessage(this.mTeamChat + "ERROR. Restart or Reload Server!");
            } else {
                this.reloadConfig();
                sender.sendMessage(this.mTeamChat + "Reloaded.");
                this.reloadConfigTeamChat();
                return true;
            }
        }
        if (sender.hasPermission("teamchat.admin.delay") && args.length == 2 && command.getName().equals(mChat) && args[0].equals("delay")) {
            this.messageDelay = Integer.parseInt(args[1]);
            sender.sendMessage(this.mTeamChat + "\u00a7aMessage Delay Set " + this.messageDelay + " sec.");
            return true;
        }
        if (sender.hasPermission("teamchat.player.chat")) {
            if (args.length == 1 && command.getName().equals(mChat) && args[0].equals("help")) {
                sender.sendMessage(this.mTeamChat + "\u00a7e/chat \u00a7b- Change Chat (global/team).");
                sender.sendMessage(this.mTeamChat + "\u00a7e/chat global \u00a7a- Change to Global Chat.");
                sender.sendMessage(this.mTeamChat + "\u00a7e/chat team \u00a79- Change to Team Chat.");
                if (sender.hasPermission("teamchat.admin.reload")) {
                    sender.sendMessage(this.mTeamChat + "\u00a7e/chat reload \u00a7b- Reload Configuration.");
                }
                if (sender.hasPermission("teamchat.admin.delay")) {
                    sender.sendMessage(this.mTeamChat + "\u00a7e/chat delay \u00a7o3 \u00a7r\u00a7b- Set Global Chat delay to 3 sec.");
                }
                sender.sendMessage(this.mTeamChat + "\u00a7aDonwload: \u00a7bhttp://dev.bukkit.org/bukkit-plugins/team-chat-scoreboard/");
                return true;
            }
            if (isPlayer) {
                Player player = (Player)sender;
                String getPrefix = "";
                if (args.length == 0 && command.getName().equals(mChat)) {
                    if (player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).getScore() == 1) {
                        player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).setScore(0);
                        sender.sendMessage(this.mTeamChat + this.messageGlobal);
                        return true;
                    }
                    player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).setScore(1);
                    sender.sendMessage(this.mTeamChat + this.messageTeam);
                    return true;
                }
                if (args.length == 1 && command.getName().equals(mChat) && "team".startsWith(args[0])) {
                    player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).setScore(1);
                    sender.sendMessage(this.mTeamChat + this.messageTeam);
                    return true;
                }
                if (args.length == 1 && command.getName().equals(mChat) && "global".startsWith(args[0])) {
                    player.getScoreboard().getObjective(this.scoreboard).getScore((OfflinePlayer)player).setScore(0);
                    sender.sendMessage(this.mTeamChat + this.messageGlobal);
                    return true;
                }
                if (args.length > 0 && command.getName().equals("team")) {
                    Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
                    Set players = team.getPlayers();
                    String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length));
                    getPrefix = this.color ? team.getPrefix() : "";
                    String nameChat = this.teamPrefix + getPrefix + player.getName() + team.getSuffix() + this.teamSufix;
                    for (OfflinePlayer current : players) {
                        if (current.getPlayer() == null) continue;
                        current.getPlayer().sendMessage(nameChat + message);
                    }
                    return true;
                }
                if (args.length > 0 && command.getName().equals("global")) {
                    Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
                    String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length));
                    getPrefix = this.color ? team.getPrefix() : "";
                    Long i = this.delays.get(player.getName());
                    if (this.messageDelay != 0 && i != null && i > System.currentTimeMillis()) {
                        Long t = (this.delays.get(player.getName()) - System.currentTimeMillis()) / 1000L;
                        player.sendMessage(this.mTeamChat + this.mDelay + t + "s.");
                        return true;
                    }
                    String nameChat = this.globalPrefix + getPrefix + player.getName() + team.getSuffix() + this.globalSufix;
                    Bukkit.broadcastMessage((String)(nameChat + message));
                    if (this.messageDelay > 0 && !sender.hasPermission("teamchat.player.delay")) {
                        this.delays.put(player.getName(), System.currentTimeMillis() + (long)(this.messageDelay * 1000));
                    }
                    return true;
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        LinkedList<String> complitions = new LinkedList<String>();
        if (sender.hasPermission("teamchat.admin.reload") && args.length == 1 && "reload".startsWith(args[0])) {
            complitions.add("reload");
        }
        if (sender.hasPermission("teamchat.admin.delay")) {
            if (args.length == 1 && "delay".startsWith(args[0])) {
                complitions.add("delay");
            }
            if (args.length == 2 && "delay".equals(args[0])) {
                complitions.add("0");
            }
        }
        if (sender.hasPermission("teamchat.player.chat")) {
            if (args.length == 1 && "help".startsWith(args[0])) {
                complitions.add("help");
            }
            if ("team".startsWith(args[0])) {
                complitions.add("team");
            }
            if ("global".startsWith(args[0])) {
                complitions.add("global");
            }
        }
        return complitions;
    }
}

