/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.storage.storage.util;

import io.aquaticlabs.storage.storage.shaded.json.JSONArray;
import io.aquaticlabs.storage.storage.shaded.json.JSONException;
import io.aquaticlabs.storage.storage.shaded.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    public static Map<String, Object> jsonToMap(JSONObject jsonObject) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (jsonObject != JSONObject.NULL) {
            retMap = JsonUtils.toMap(jsonObject);
        }
        return retMap;
    }

    public static JSONObject getJsonFromMap(Map<String, Object> map) throws JSONException {
        JSONObject jsonData = new JSONObject();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                value = JsonUtils.getJsonFromMap((Map)value);
            }
            jsonData.put(key, value);
        }
        return jsonData;
    }

    public static Map<String, Object> toMap(JSONObject jsonObject) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator<String> keysItr = jsonObject.keys();
        keysItr.forEachRemaining(key -> map.put((String)key, JsonUtils.getValue(jsonObject.get((String)key))));
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(JsonUtils.getValue(array.get(i)));
        }
        return list;
    }

    private static Object getValue(Object obj) {
        if (obj instanceof JSONArray) {
            return JsonUtils.toList((JSONArray)obj);
        }
        if (obj instanceof JSONObject) {
            return JsonUtils.toMap((JSONObject)obj);
        }
        return obj;
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

