/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.storage.storage.internal;

import io.aquaticlabs.storage.storage.util.FileUtils;
import java.io.File;

public enum FileType {
    JSON("json"),
    YAML("yml"),
    TOML("toml");

    private final String extension;

    public static FileType fromFile(File file) {
        return FileType.fromExtension(FileUtils.getExtension(file));
    }

    public static FileType fromExtension(String type) {
        for (FileType value : FileType.values()) {
            if (!value.extension.equalsIgnoreCase(type)) continue;
            return value;
        }
        return null;
    }

    public static FileType fromExtension(File file) {
        return FileType.fromExtension(FileUtils.getExtension(file));
    }

    public String getExtension() {
        return this.extension;
    }

    private FileType(String extension) {
        this.extension = extension;
    }
}

