/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.storage.storage;

import io.aquaticlabs.storage.storage.Config;
import io.aquaticlabs.storage.storage.Json;
import io.aquaticlabs.storage.storage.Toml;
import io.aquaticlabs.storage.storage.Yaml;
import io.aquaticlabs.storage.storage.internal.provider.InputStreamProvider;
import io.aquaticlabs.storage.storage.internal.provider.LightningProviders;
import io.aquaticlabs.storage.storage.internal.settings.ConfigSettings;
import io.aquaticlabs.storage.storage.internal.settings.DataType;
import io.aquaticlabs.storage.storage.internal.settings.ReloadSettings;
import io.aquaticlabs.storage.storage.shaded.jetbrains.annotations.Nullable;
import io.aquaticlabs.storage.storage.util.FileUtils;
import io.aquaticlabs.storage.storage.util.Valid;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import lombok.NonNull;

public final class LightningBuilder {
    private final InputStreamProvider inputStreamProvider;
    private final String path;
    private String name;
    private InputStream inputStream;
    private ReloadSettings reloadSettings;
    private ConfigSettings configSettings;
    private DataType dataType;

    private LightningBuilder(String name, String path, InputStreamProvider inputStreamProvider) {
        this.name = name;
        this.path = path;
        this.inputStreamProvider = inputStreamProvider;
    }

    public static LightningBuilder fromPath(@NonNull String name, @NonNull String path) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new LightningBuilder(name, path, LightningProviders.inputStreamProvider());
    }

    public static LightningBuilder fromPath(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return LightningBuilder.fromFile(path.toFile());
    }

    public static LightningBuilder fromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.isDirectory(), "File mustn't be a directory.", "Please use from Directory to use a directory", "This is due to Java-Internals");
        return new LightningBuilder(FileUtils.replaceExtensions(file.getName()), FileUtils.getParentDirPath(file), LightningProviders.inputStreamProvider());
    }

    public static LightningBuilder fromDirectory(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Valid.checkBoolean(!file.getName().contains("."), "File-Name mustn't contain '.'");
        if (!file.exists()) {
            file.mkdirs();
        }
        return new LightningBuilder(file.getName(), file.getAbsolutePath(), LightningProviders.inputStreamProvider());
    }

    public LightningBuilder addInputStreamFromFile(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.inputStream = FileUtils.createInputStream(file);
        return this;
    }

    public LightningBuilder addInputStreamFromResource(@NonNull String resource) {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.inputStream = this.inputStreamProvider.createInputStreamFromInnerResource(resource);
        Valid.notNull(this.inputStream, "InputStream is null.", "No inbuilt resource '" + resource + "' found: ");
        return this;
    }

    public LightningBuilder setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    public LightningBuilder addInputStream(@Nullable InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public LightningBuilder setConfigSettings(@NonNull ConfigSettings configSettings) {
        if (configSettings == null) {
            throw new NullPointerException("configSettings is marked non-null but is null");
        }
        this.configSettings = configSettings;
        return this;
    }

    public LightningBuilder setReloadSettings(@NonNull ReloadSettings reloadSettings) {
        if (reloadSettings == null) {
            throw new NullPointerException("reloadSettings is marked non-null but is null");
        }
        this.reloadSettings = reloadSettings;
        return this;
    }

    public LightningBuilder setDataType(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        this.dataType = dataType;
        return this;
    }

    public Config createConfig() {
        return new Config(this.name, this.path, this.inputStream, this.reloadSettings, this.configSettings, this.dataType);
    }

    public Yaml createYaml() {
        return new Yaml(this.name, this.path, this.inputStream, this.reloadSettings, this.configSettings, this.dataType);
    }

    public Toml createToml() {
        return new Toml(this.name, this.path, this.inputStream, this.reloadSettings);
    }

    public Json createJson() {
        return new Json(this.name, this.path, this.inputStream, this.reloadSettings);
    }
}

