/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.utils.files;

import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.utils.Utilities;
import io.aquaticlabs.storage.storage.Config;
import io.aquaticlabs.storage.storage.sections.FlatFileSection;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;

public class ConfigFile {
    private final StatsSB plugin;
    private final Config config;
    private boolean updateChecking;
    private boolean disableCertainWorlds;
    private List<String> enabledWorlds;
    private boolean trackKillStreaks;
    private boolean scoreboardEnabled;
    private boolean scoreboardToggledByDefault;
    private boolean resetScoreboardToggleOnJoin;
    private String scoreboardToggleOn;
    private String scoreboardToggleOff;
    private String dateTimeZone;
    private String dateFormat;
    private boolean economyEnabled;
    private String scoreboardTitle;
    private List<String> scoreboardLayout;
    private boolean statsCommandEnabled;
    private boolean statsCommandEnablePermission;
    private String statsCommandNoPermission;
    private List<String> statsCommandMessage;
    private String type;
    private String databaseName;
    private String hostname;
    private int port;
    private String username;
    private String password;
    private int leaderboardUpdateTime;
    private int leaderboardNumberOfPlayers;
    private String leaderboardPlayerFormat;
    private String leaderboardKillsTitle;
    private String leaderboardDeathsTitle;
    private List<String> leaderboardMessage;
    private int hologramNumberOfPlayers;
    private String hologramKillsTitle;
    private String hologramDeathsTitle;
    private String hologramPlayerFormat;

    public ConfigFile(StatsSB plugin, Config config) {
        this.plugin = plugin;
        this.config = config;
        this.updateChecking = config.getBoolean("MainOptions.updateChecker");
        this.disableCertainWorlds = config.getBoolean("MainOptions.disableCertainWorldStats");
        this.enabledWorlds = config.getStringList("MainOptions.enabledWorlds");
        this.trackKillStreaks = config.getBoolean("MainOptions.KillStreaks.enabled");
        this.scoreboardEnabled = config.getBoolean("Scoreboard.enabled");
        this.scoreboardToggledByDefault = config.getBoolean("Scoreboard.toggledByDefault");
        this.scoreboardToggleOn = this.replace(config.getString("Scoreboard.toggleSBMessageOn"));
        this.resetScoreboardToggleOnJoin = config.getBoolean("Scoreboard.resetScoreboardToggleOnJoin");
        this.scoreboardToggleOff = this.replace(config.getString("Scoreboard.toggleSBMessageOff"));
        this.dateTimeZone = config.getString("Scoreboard.dateTimeZone");
        this.dateFormat = config.getString("Scoreboard.dateFormat");
        this.economyEnabled = config.getBoolean("Scoreboard.Economy.enabled");
        this.scoreboardTitle = this.replace(config.getString("Scoreboard.title"));
        this.scoreboardLayout = this.replace(config.getStringList("Scoreboard.layout"));
        this.statsCommandEnabled = config.getBoolean("StatsCommand.enabled");
        this.statsCommandEnablePermission = config.getBoolean("StatsCommand.enable-permission");
        this.statsCommandNoPermission = this.replace(config.getString("StatsCommand.no-permission-message"));
        this.statsCommandMessage = this.replace(config.getStringList("StatsCommand.message"));
        FlatFileSection databaseSection = config.getSection("database");
        this.type = databaseSection.getString("type");
        this.databaseName = databaseSection.getString("database");
        this.hostname = databaseSection.getString("hostname");
        this.port = databaseSection.getInt("port");
        this.username = databaseSection.getString("username");
        this.password = databaseSection.getString("password");
        this.leaderboardUpdateTime = config.getInt("Leaderboard.update-time-in-seconds");
        this.leaderboardNumberOfPlayers = config.getInt("Leaderboard.number-of-players-to-show");
        this.leaderboardPlayerFormat = this.replace(config.getString("Leaderboard.playerFormat"));
        this.leaderboardKillsTitle = this.replace(config.getString("Leaderboard.killsTitle"));
        this.leaderboardDeathsTitle = this.replace(config.getString("Leaderboard.deathsTitle"));
        this.leaderboardMessage = this.replace(config.getStringList("Leaderboard.message"));
        this.hologramNumberOfPlayers = config.getInt("Holograms.number-of-players-to-show");
        this.hologramKillsTitle = this.replace(config.getString("Holograms.killsTitle"));
        this.hologramDeathsTitle = this.replace(config.getString("Holograms.deathsTitle"));
        this.hologramPlayerFormat = this.replace(config.getString("Holograms.playerFormat"));
    }

    private List<String> replace(List<String> list) {
        ArrayList<String> replaced = new ArrayList<String>();
        for (String s : list) {
            if (s == null) continue;
            s = s.replace("%blank-1%", ChatColor.RESET.toString() + "").replace("%blank-2%", ChatColor.RESET.toString() + "" + ChatColor.RESET.toString()).replace("%blank-3%", ChatColor.RESET.toString() + " ").replace("%blank-4%", ChatColor.RESET.toString() + "  ").replace("%blank-5%", ChatColor.RESET.toString() + "   ").replace("%blank-6%", ChatColor.RESET.toString() + "    ");
            replaced.add(Utilities.replaceColorCodes(s));
        }
        return replaced;
    }

    private String replace(String s) {
        return Utilities.replaceColorCodes(s);
    }

    public StatsSB getPlugin() {
        return this.plugin;
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean isUpdateChecking() {
        return this.updateChecking;
    }

    public boolean isDisableCertainWorlds() {
        return this.disableCertainWorlds;
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public boolean isTrackKillStreaks() {
        return this.trackKillStreaks;
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public boolean isScoreboardToggledByDefault() {
        return this.scoreboardToggledByDefault;
    }

    public boolean isResetScoreboardToggleOnJoin() {
        return this.resetScoreboardToggleOnJoin;
    }

    public String getScoreboardToggleOn() {
        return this.scoreboardToggleOn;
    }

    public String getScoreboardToggleOff() {
        return this.scoreboardToggleOff;
    }

    public String getDateTimeZone() {
        return this.dateTimeZone;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public String getScoreboardTitle() {
        return this.scoreboardTitle;
    }

    public List<String> getScoreboardLayout() {
        return this.scoreboardLayout;
    }

    public boolean isStatsCommandEnabled() {
        return this.statsCommandEnabled;
    }

    public boolean isStatsCommandEnablePermission() {
        return this.statsCommandEnablePermission;
    }

    public String getStatsCommandNoPermission() {
        return this.statsCommandNoPermission;
    }

    public List<String> getStatsCommandMessage() {
        return this.statsCommandMessage;
    }

    public String getType() {
        return this.type;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getLeaderboardUpdateTime() {
        return this.leaderboardUpdateTime;
    }

    public int getLeaderboardNumberOfPlayers() {
        return this.leaderboardNumberOfPlayers;
    }

    public String getLeaderboardPlayerFormat() {
        return this.leaderboardPlayerFormat;
    }

    public String getLeaderboardKillsTitle() {
        return this.leaderboardKillsTitle;
    }

    public String getLeaderboardDeathsTitle() {
        return this.leaderboardDeathsTitle;
    }

    public List<String> getLeaderboardMessage() {
        return this.leaderboardMessage;
    }

    public int getHologramNumberOfPlayers() {
        return this.hologramNumberOfPlayers;
    }

    public String getHologramKillsTitle() {
        return this.hologramKillsTitle;
    }

    public String getHologramDeathsTitle() {
        return this.hologramDeathsTitle;
    }

    public String getHologramPlayerFormat() {
        return this.hologramPlayerFormat;
    }

    public void setUpdateChecking(boolean updateChecking) {
        this.updateChecking = updateChecking;
    }

    public void setDisableCertainWorlds(boolean disableCertainWorlds) {
        this.disableCertainWorlds = disableCertainWorlds;
    }

    public void setEnabledWorlds(List<String> enabledWorlds) {
        this.enabledWorlds = enabledWorlds;
    }

    public void setTrackKillStreaks(boolean trackKillStreaks) {
        this.trackKillStreaks = trackKillStreaks;
    }

    public void setScoreboardEnabled(boolean scoreboardEnabled) {
        this.scoreboardEnabled = scoreboardEnabled;
    }

    public void setScoreboardToggledByDefault(boolean scoreboardToggledByDefault) {
        this.scoreboardToggledByDefault = scoreboardToggledByDefault;
    }

    public void setResetScoreboardToggleOnJoin(boolean resetScoreboardToggleOnJoin) {
        this.resetScoreboardToggleOnJoin = resetScoreboardToggleOnJoin;
    }

    public void setScoreboardToggleOn(String scoreboardToggleOn) {
        this.scoreboardToggleOn = scoreboardToggleOn;
    }

    public void setScoreboardToggleOff(String scoreboardToggleOff) {
        this.scoreboardToggleOff = scoreboardToggleOff;
    }

    public void setDateTimeZone(String dateTimeZone) {
        this.dateTimeZone = dateTimeZone;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setEconomyEnabled(boolean economyEnabled) {
        this.economyEnabled = economyEnabled;
    }

    public void setScoreboardTitle(String scoreboardTitle) {
        this.scoreboardTitle = scoreboardTitle;
    }

    public void setScoreboardLayout(List<String> scoreboardLayout) {
        this.scoreboardLayout = scoreboardLayout;
    }

    public void setStatsCommandEnabled(boolean statsCommandEnabled) {
        this.statsCommandEnabled = statsCommandEnabled;
    }

    public void setStatsCommandEnablePermission(boolean statsCommandEnablePermission) {
        this.statsCommandEnablePermission = statsCommandEnablePermission;
    }

    public void setStatsCommandNoPermission(String statsCommandNoPermission) {
        this.statsCommandNoPermission = statsCommandNoPermission;
    }

    public void setStatsCommandMessage(List<String> statsCommandMessage) {
        this.statsCommandMessage = statsCommandMessage;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLeaderboardUpdateTime(int leaderboardUpdateTime) {
        this.leaderboardUpdateTime = leaderboardUpdateTime;
    }

    public void setLeaderboardNumberOfPlayers(int leaderboardNumberOfPlayers) {
        this.leaderboardNumberOfPlayers = leaderboardNumberOfPlayers;
    }

    public void setLeaderboardPlayerFormat(String leaderboardPlayerFormat) {
        this.leaderboardPlayerFormat = leaderboardPlayerFormat;
    }

    public void setLeaderboardKillsTitle(String leaderboardKillsTitle) {
        this.leaderboardKillsTitle = leaderboardKillsTitle;
    }

    public void setLeaderboardDeathsTitle(String leaderboardDeathsTitle) {
        this.leaderboardDeathsTitle = leaderboardDeathsTitle;
    }

    public void setLeaderboardMessage(List<String> leaderboardMessage) {
        this.leaderboardMessage = leaderboardMessage;
    }

    public void setHologramNumberOfPlayers(int hologramNumberOfPlayers) {
        this.hologramNumberOfPlayers = hologramNumberOfPlayers;
    }

    public void setHologramKillsTitle(String hologramKillsTitle) {
        this.hologramKillsTitle = hologramKillsTitle;
    }

    public void setHologramDeathsTitle(String hologramDeathsTitle) {
        this.hologramDeathsTitle = hologramDeathsTitle;
    }

    public void setHologramPlayerFormat(String hologramPlayerFormat) {
        this.hologramPlayerFormat = hologramPlayerFormat;
    }
}

