/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.utils;

import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.data.PlayerData;
import io.aquaticlabs.statssb.events.PlayerStreakBrokeEvent;
import io.aquaticlabs.statssb.leaderboards.Leaderboard;
import io.aquaticlabs.statssb.stat.StatType;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerStatManager {
    private StatsSB plugin;

    public PlayerStatManager(StatsSB plugin) {
        this.plugin = plugin;
    }

    public void addStatAsync(PlayerData user, StatType statType, Object amount) {
        this.addStatAsync(user, null, statType, amount);
    }

    public void addStatAsync(PlayerData user, PlayerData attacker, StatType statType, Object amount) {
        Leaderboard leaderboard = this.plugin.getLeaderboards().get((Object)statType);
        int oldStreak = (Integer)user.getStat(StatType.KILL_STREAK).getValue();
        user.addStat(statType, amount);
        if (statType == StatType.KILL) {
            user.addStat(StatType.KILL_STREAK, amount);
        }
        if (statType == StatType.DEATH) {
            user.setStat(StatType.KILL_STREAK, 0);
        }
        this.plugin.getPlayerDataHolder().saveSingle(user, true);
        leaderboard.setStatsChanged(true);
        if (attacker == null) {
            return;
        }
        if (statType == StatType.DEATH) {
            if (attacker.getUuid() == user.getUuid()) {
                Player player = Bukkit.getPlayer((UUID)attacker.getUuid());
                PlayerStreakBrokeEvent streakBrokeEvent = new PlayerStreakBrokeEvent(player, player, oldStreak);
                Bukkit.getPluginManager().callEvent((Event)streakBrokeEvent);
                return;
            }
            PlayerStreakBrokeEvent streakBrokeEvent = new PlayerStreakBrokeEvent(Bukkit.getPlayer((UUID)attacker.getUuid()), Bukkit.getPlayer((UUID)user.getUuid()), oldStreak);
            Bukkit.getPluginManager().callEvent((Event)streakBrokeEvent);
        }
    }

    public void setStatAsync(PlayerData user, StatType statType, Object amount) {
        Leaderboard leaderboard = this.plugin.getLeaderboards().get((Object)statType);
        user.setStat(statType, amount);
        this.plugin.getPlayerDataHolder().saveSingle(user, true);
        leaderboard.setStatsChanged(true);
    }

    public void removeStatAsync(PlayerData user, StatType statType, Object amount) {
        Leaderboard leaderboard = this.plugin.getLeaderboards().get((Object)statType);
        user.removeStat(statType, amount);
        this.plugin.getPlayerDataHolder().saveSingle(user, true);
        leaderboard.setStatsChanged(true);
    }
}

