/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.utils;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public class MathUtil {
    public static double roundTwoDecimals(double d) {
        d = Math.round(d * 100.0);
        return d /= 100.0;
    }

    public static boolean isInt(double d) {
        return d == (double)((int)d);
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int getInt(double d) {
        return (int)d;
    }

    public static double roundDecimal(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static String addCommas(int i) {
        if (i < 1000) {
            return Integer.toString(i);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        return numberFormat.format(i);
    }

    public static Integer randomNumber(int min, int max) {
        Random i = new Random();
        if (max == min) {
            return max;
        }
        return min + i.nextInt(max - min);
    }

    public static double calculatePercentage(double obtained, double total) {
        return obtained * 100.0 / total;
    }

    public static String addCommas(Object o) {
        if (o instanceof Integer) {
            int i = (Integer)o;
            if (i < 1000) {
                return Integer.toString(i);
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
            return numberFormat.format(i);
        }
        double d = (Double)o;
        if (d < 1000.0) {
            return Double.toString(d);
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        return numberFormat.format(d);
    }

    public static long stringToSeed(String s) {
        if (s == null) {
            return 0L;
        }
        long hash = 0L;
        for (char c : s.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        return hash;
    }
}

