/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.stat;

import io.aquaticlabs.statssb.stat.StatType;

public class Stat {
    private final StatType type;
    private Object value = 0;
    private int rank = 0;

    public Stat(StatType type) {
        this.type = type;
    }

    public Stat(StatType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Stat(StatType type, Object value, int rank) {
        this.type = type;
        this.value = value;
        this.rank = rank;
    }

    public void addNumberValue(Object amount) {
        if (this.type.getType() == Integer.TYPE) {
            int oldVal = (Integer)this.value;
            int amToAdd = (Integer)amount;
            this.setValue(oldVal + amToAdd);
            return;
        }
        double oldVal = ((Number)this.value).doubleValue();
        double amToAdd = ((Number)amount).doubleValue();
        this.setValue(oldVal + amToAdd);
    }

    public void removeNumberValue(Object amount) {
        if (this.type.getType() == Integer.TYPE) {
            int oldVal = (Integer)this.value;
            int amToRem = (Integer)amount;
            int updatedVal = Math.max(oldVal - amToRem, 0);
            this.setValue(updatedVal);
            return;
        }
        double oldVal = ((Number)this.value).doubleValue();
        double amToRem = ((Number)amount).doubleValue();
        double updatedVal = Math.max(oldVal - amToRem, 0.0);
        this.setValue(updatedVal);
    }

    public StatType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }
}

