/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.leaderboards;

import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.leaderboards.Leaderboard;
import io.aquaticlabs.statssb.utils.DebugLogger;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LeaderboardThread {
    private final StatsSB plugin;
    private BukkitTask taskID;
    private final int timeBetweenUpdates;
    private int updateTimeLeft = 0;

    public LeaderboardThread(StatsSB plugin, int timeBetweenUpdates) {
        this.plugin = plugin;
        this.timeBetweenUpdates = timeBetweenUpdates;
        this.start();
    }

    private void start() {
        if (this.taskID != null) {
            return;
        }
        this.updateTimeLeft = this.timeBetweenUpdates;
        this.taskID = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.updateTimeLeft <= 0) {
                for (Leaderboard leaderboard : this.plugin.getLeaderboards().values()) {
                    boolean b = leaderboard.buildIfChanged();
                    if (!b) {
                        DebugLogger.logDebugMessage("&cLeaderboard: " + leaderboard.getStatType().name() + " Unchanged, Skipping");
                        continue;
                    }
                    DebugLogger.logDebugMessage("&cLeaderboard: " + leaderboard.getStatType().name() + " Rebuilding.");
                }
                this.updateTimeLeft = this.timeBetweenUpdates;
            }
            --this.updateTimeLeft;
        }, 20L, 20L);
    }

    public int getUpdateTimeLeft() {
        return this.updateTimeLeft;
    }
}

