/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.data;

import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.StorageHolder;
import io.aquaticlabs.aquaticdata.data.storage.StorageMode;
import io.aquaticlabs.aquaticdata.data.type.DataCredential;
import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.data.PlayerData;
import io.aquaticlabs.statssb.utils.DebugLogger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerDataHolder
extends StorageHolder<PlayerData> {
    private final StatsSB plugin;
    private Map<UUID, PlayerData> data = new ConcurrentHashMap<UUID, PlayerData>();

    public PlayerDataHolder(StatsSB plugin, DataCredential credential) {
        super(credential, PlayerData.class, StorageMode.LOAD_AND_STORE);
        this.plugin = plugin;
        this.loadAll(false);
    }

    @Override
    protected void onAdd(PlayerData playerData) {
        DebugLogger.logDebugMessage("Adding new Player to dataset: " + playerData.getUuid());
        this.data.put(playerData.getUuid(), playerData);
    }

    @Override
    protected void onRemove(PlayerData playerData) {
        this.data.remove(playerData.getUuid());
    }

    @Override
    public void removeDataObj(DataObject key) {
        UUID uuid = UUID.fromString((String)key.getKey());
        PlayerData pData = this.data.get(uuid);
        if (pData == null) {
            DebugLogger.logDebugMessage("Failed to find a loaded PlayerData to remove.");
            return;
        }
        this.remove(pData);
    }

    @Override
    public Iterator<PlayerData> iterator() {
        return this.data.values().iterator();
    }

    public PlayerData getOrNull(UUID uuid) {
        return this.data.get(uuid);
    }

    public PlayerData getOrInsert(UUID uuid) {
        PlayerData playerData = this.data.get(uuid);
        if (playerData == null) {
            playerData = new PlayerData(this.plugin, uuid);
            this.add(playerData);
        }
        return playerData;
    }

    public Set<String> getAllNames() {
        HashSet<String> userNames = new HashSet<String>();
        for (PlayerData entry : this.data.values()) {
            userNames.add(entry.getName());
        }
        return userNames;
    }

    public Set<PlayerData> getAllPlayerDatas() {
        return new HashSet<PlayerData>(this.data.values());
    }

    public Set<UUID> getAllUUIDs() {
        return new HashSet<UUID>(this.data.keySet());
    }

    public Set<String> getAllNamesLowercase() {
        HashSet<String> userNames = new HashSet<String>();
        for (PlayerData entry : this.data.values()) {
            userNames.add(entry.getName().toLowerCase());
        }
        return userNames;
    }

    public Map<UUID, PlayerData> getData() {
        return this.data;
    }
}

