/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.commands.sb;

import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.commands.Subcommand;
import io.aquaticlabs.statssb.hologram.HologramManager;
import io.aquaticlabs.statssb.hologram.StatHologram;
import io.aquaticlabs.statssb.stat.StatType;
import io.aquaticlabs.statssb.utils.Permission;
import io.aquaticlabs.statssb.utils.Utilities;
import io.aquaticlabs.statssb.utils.files.MessageHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SBHologramSubcommand
implements Subcommand {
    private final StatsSB plugin;

    public SBHologramSubcommand(StatsSB plugin) {
        this.plugin = plugin;
    }

    public String getHelp() {
        return "Create or Delete holograms";
    }

    public String getUsage() {
        return MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_USAGE);
    }

    @Override
    public Permission getPermission() {
        return Permission.ADMIN;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.PLAYER_REQUIRED));
            return true;
        }
        Player player = (Player)sender;
        File holofile = new File(this.plugin.getDataFolder(), "holograms.yml");
        YamlConfiguration holoList = YamlConfiguration.loadConfiguration((File)holofile);
        if (args.length == 1) {
            player.sendMessage(this.getUsage());
            return true;
        }
        if (!this.plugin.isUseHolographicDisplays()) {
            player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_NO_HDDISPLAYS));
            return true;
        }
        HologramManager hologramManager = this.plugin.getHologramManager();
        if (args[1].equalsIgnoreCase("delete")) {
            if (args.length > 3) {
                player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_DELETE_USAGE));
                return true;
            }
            String name = args[2];
            boolean exists = false;
            StatHologram sbHologram = null;
            if (this.plugin.getHologramManager().getHolograms().containsKey(name)) {
                exists = true;
                sbHologram = hologramManager.getHolograms().get(name);
            }
            if (!exists) {
                player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_DELETE_NOT_EXIST).replace("%name%", name));
                return true;
            }
            holoList.set("holograms." + name, null);
            Utilities.saveFile(holofile, (FileConfiguration)holoList);
            sbHologram.delete();
            hologramManager.getHolograms().remove(name);
            player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_DELETE_DONE).replace("%name%", name));
            return true;
        }
        if (args[1].equalsIgnoreCase("create")) {
            if (args.length != 4) {
                player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_CREATE_USAGE));
                return true;
            }
            StatType statType = StatType.matchStatType(args[3]);
            if (statType == null) {
                statType = StatType.matchCommonNameStat(args[3]);
            }
            if (statType == null) {
                sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.PREFIX) + ChatColor.RED + args[3] + ChatColor.GRAY + " is not a valid StatType.");
                StringBuilder types = new StringBuilder();
                for (StatType statType1 : StatType.values()) {
                    types.append(statType1.name()).append(", ");
                }
                sender.sendMessage(ChatColor.GRAY + "Valid Types are:");
                sender.sendMessage(ChatColor.AQUA + types.toString());
                return true;
            }
            String name = args[2].toLowerCase();
            boolean exists = false;
            for (StatHologram statHologram : hologramManager.getHolograms().values()) {
                if (!statHologram.getId().equalsIgnoreCase(name)) continue;
                exists = true;
                break;
            }
            if (exists) {
                player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_CREATE_EXISTS).replace("%name%", name));
                return true;
            }
            String type = statType.getCommonName();
            holoList.set("holograms." + name + ".type", (Object)type);
            holoList.set("holograms." + name + ".location.world", (Object)player.getLocation().getWorld().getName());
            holoList.set("holograms." + name + ".location.x", (Object)player.getLocation().getX());
            holoList.set("holograms." + name + ".location.y", (Object)player.getLocation().getY());
            holoList.set("holograms." + name + ".location.z", (Object)player.getLocation().getZ());
            Utilities.saveFile(holofile, (FileConfiguration)holoList);
            Utilities.reloadBoard(this.plugin, statType);
            hologramManager.create(name, statType, player.getLocation().add(0.0, 1.0, 0.0));
            player.sendMessage(MessageHandler.getMessage(MessageHandler.Message.HOLOGRAM_CREATE_DONE).replace("%name%", name));
            return true;
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String[] args) {
        if (args.length == 2) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("create");
            list.add("delete");
            return list;
        }
        if (args.length == 3) {
            if (args[1].equalsIgnoreCase("create")) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("<name>");
                return list;
            }
            if (args[1].equalsIgnoreCase("delete")) {
                return new ArrayList<String>(this.plugin.getHologramManager().getHolograms().keySet());
            }
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("create")) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("kill");
            list.add("death");
            return list;
        }
        return new ArrayList<String>();
    }
}

