/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.commands;

import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.commands.BaseCommand;
import io.aquaticlabs.statssb.commands.Subcommand;
import io.aquaticlabs.statssb.utils.Permission;
import io.aquaticlabs.statssb.utils.files.MessageHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final StatsSB plugin;
    private final BaseCommand baseCommand;
    private Map<String, Subcommand> subcommands;

    public CommandManager(StatsSB plugin, BaseCommand baseCommand, Map<String, Subcommand> subcommands) {
        this.plugin = plugin;
        this.baseCommand = baseCommand;
        this.subcommands = subcommands;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            if (this.baseCommand.getPermission() == null) {
                return this.baseCommand.onCommand(sender, cmd, args);
            }
            if (!Permission.hasPermission(sender, this.baseCommand.getPermission())) {
                sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.NO_PERMISSION));
                return true;
            }
            return this.baseCommand.onCommand(sender, cmd);
        }
        if (this.subcommands.isEmpty()) {
            return this.baseCommand.onCommand(sender, cmd, args);
        }
        Subcommand subcommand = this.subcommands.get(args[0]);
        if (subcommand == null) {
            subcommand = this.subcommands.get("help");
        }
        if (subcommand.getPermission() != null && !Permission.hasPermission(sender, subcommand.getPermission())) {
            sender.sendMessage(MessageHandler.getMessage(MessageHandler.Message.NO_PERMISSION));
            return true;
        }
        return subcommand.onCommand(sender, cmd, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.subcommands.isEmpty()) {
            return this.baseCommand.onTabComplete(sender, cmd, args);
        }
        if (args.length == 1) {
            ArrayList<String> keySet = new ArrayList<String>(this.subcommands.keySet());
            ArrayList<String> tabList = new ArrayList<String>();
            for (String key : keySet) {
                if (this.subcommands.get(key).getPermission() == null) {
                    tabList.add(key);
                    continue;
                }
                if (!Permission.hasPermission(sender, this.subcommands.get(key).getPermission())) continue;
                tabList.add(key);
            }
            ArrayList newList = new ArrayList();
            StringUtil.copyPartialMatches((String)args[0], tabList, newList);
            Collections.sort(newList);
            return tabList;
        }
        Subcommand subcommand = this.subcommands.get(args[0]);
        if (subcommand == null) {
            try {
                subcommand = this.subcommands.get("help");
            }
            catch (NullPointerException e) {
                return new ArrayList<String>();
            }
        }
        return subcommand.onTabComplete(sender, cmd, args);
    }
}

