/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb.board;

import fr.mrmicky.fastboard.FastBoard;
import io.aquaticlabs.statssb.StatsSB;
import io.aquaticlabs.statssb.data.PlayerData;
import io.aquaticlabs.statssb.utils.DebugLogger;
import io.aquaticlabs.statssb.utils.Utilities;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Board {
    private final StatsSB plugin;
    private PlayerData player;
    private FastBoard fastBoard;
    private BukkitTask updateBoardTaskID;
    private BukkitTask updateTitleTaskID;
    private boolean isAllowed = true;
    private boolean isToggledOn = true;
    private String title;
    private List<String> values;
    private Player p;

    public Board(StatsSB plugin) {
        this.plugin = plugin;
    }

    public Board(StatsSB plugin, PlayerData player) {
        this.plugin = plugin;
        this.player = player;
        this.isAllowed = plugin.getFileUtil().getConfigFile().isScoreboardEnabled();
    }

    public boolean isActive() {
        return this.updateBoardTaskID != null;
    }

    public FastBoard get() {
        return this.fastBoard;
    }

    public boolean start() {
        this.p = Objects.requireNonNull(Bukkit.getPlayer((UUID)this.player.getUuid()));
        return this.start(0);
    }

    public void restart() {
        this.remove();
        this.start();
    }

    public boolean start(int delay) {
        if (!this.isAllowed || !this.isToggledOn) {
            DebugLogger.logDebugMessage("Tried to start a new scoreboard task when the the board is not allowed or the players board is not toggled.");
            return false;
        }
        try {
            if (this.updateBoardTaskID != null) {
                DebugLogger.logDebugMessage("Tried to start a new scoreboard task when one is already running.");
                return true;
            }
            this.updateBoardTaskID = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::updateBoard, (long)delay, 20L);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean pause() {
        return this.cancel();
    }

    public boolean cancel() {
        return this.cancelBoard() && this.cancelTitle();
    }

    private boolean cancelTitle() {
        try {
            if (this.updateTitleTaskID == null) {
                return true;
            }
            this.updateTitleTaskID.cancel();
        }
        catch (Exception e) {
            return false;
        }
        this.updateTitleTaskID = null;
        return true;
    }

    private boolean cancelBoard() {
        try {
            if (this.updateBoardTaskID == null) {
                return true;
            }
            this.updateBoardTaskID.cancel();
        }
        catch (Exception e) {
            return false;
        }
        this.updateBoardTaskID = null;
        return true;
    }

    public void remove() {
        this.cancel();
        if (this.fastBoard != null) {
            this.fastBoard.delete();
        }
        this.fastBoard = new FastBoard(Objects.requireNonNull(Bukkit.getPlayer((UUID)this.player.getUuid())));
        this.fastBoard.delete();
        this.fastBoard = null;
    }

    private void updateBoard() {
        if (this.fastBoard == null) {
            this.fastBoard = new FastBoard(this.p);
        }
        int limit = 300;
        if (!Utilities.getFullLength()) {
            limit = 30;
        }
        this.values = this.player.replacePlaceholders(this.getScoreboardForPlayer(this.p), limit);
        this.fastBoard.updateLines(this.values);
        this.title = this.player.replacePlaceholders(this.getScoreboardTitleForPlayer(this.p), limit);
        this.fastBoard.updateTitle(this.title);
    }

    private List<String> getScoreboardForPlayer(Player player) {
        return this.plugin.getFileUtil().getConfigFile().getScoreboardLayout();
    }

    private String getScoreboardTitleForPlayer(Player player) {
        return this.plugin.getFileUtil().getConfigFile().getScoreboardTitle();
    }

    public FastBoard getFastBoard() {
        return this.fastBoard;
    }

    public BukkitTask getUpdateBoardTaskID() {
        return this.updateBoardTaskID;
    }

    public void setUpdateBoardTaskID(BukkitTask updateBoardTaskID) {
        this.updateBoardTaskID = updateBoardTaskID;
    }

    public BukkitTask getUpdateTitleTaskID() {
        return this.updateTitleTaskID;
    }

    public void setUpdateTitleTaskID(BukkitTask updateTitleTaskID) {
        this.updateTitleTaskID = updateTitleTaskID;
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setAllowed(boolean isAllowed) {
        this.isAllowed = isAllowed;
    }

    public boolean isToggledOn() {
        return this.isToggledOn;
    }

    public void setToggledOn(boolean isToggledOn) {
        this.isToggledOn = isToggledOn;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

