/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.statssb;

import io.aquaticlabs.aquaticdata.AquaticDatabase;
import io.aquaticlabs.aquaticdata.data.type.DataCredential;
import io.aquaticlabs.statssb.Events;
import io.aquaticlabs.statssb.StatsSBAPI;
import io.aquaticlabs.statssb.commands.CommandManager;
import io.aquaticlabs.statssb.commands.Subcommand;
import io.aquaticlabs.statssb.commands.lb.LeaderboardBaseCommand;
import io.aquaticlabs.statssb.commands.sb.SBAddSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBBaseCommand;
import io.aquaticlabs.statssb.commands.sb.SBDisplaysSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBHelpSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBHologramSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBReloadSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBRemoveSubcommand;
import io.aquaticlabs.statssb.commands.sb.SBSetSubcommand;
import io.aquaticlabs.statssb.commands.stats.StatsBaseCommand;
import io.aquaticlabs.statssb.commands.tsb.TSBBaseCommand;
import io.aquaticlabs.statssb.data.PlayerData;
import io.aquaticlabs.statssb.data.PlayerDataHolder;
import io.aquaticlabs.statssb.hologram.HologramManager;
import io.aquaticlabs.statssb.leaderboards.Leaderboard;
import io.aquaticlabs.statssb.leaderboards.LeaderboardThread;
import io.aquaticlabs.statssb.metrics.Metrics;
import io.aquaticlabs.statssb.stat.StatType;
import io.aquaticlabs.statssb.update.Update;
import io.aquaticlabs.statssb.utils.DebugLogger;
import io.aquaticlabs.statssb.utils.PlayerStatManager;
import io.aquaticlabs.statssb.utils.Utilities;
import io.aquaticlabs.statssb.utils.files.ConfigFile;
import io.aquaticlabs.statssb.utils.files.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class StatsSB
extends JavaPlugin {
    private static StatsSB instance;
    private PlayerStatManager playerStatManager;
    FileUtil fileUtil;
    private final Map<StatType, Leaderboard> leaderboards = new HashMap<StatType, Leaderboard>();
    private LeaderboardThread leaderboardThread;
    private HologramManager hologramManager;
    private PlayerDataHolder playerDataHolder;
    private Economy econ;
    private boolean useHolographicDisplays = false;
    private boolean needsUpdate = false;
    private boolean debug = false;

    public void onEnable() {
        instance = this;
        DebugLogger.setDebug(this.debug);
        new StatsSBAPI(this);
        this.reloadFileUtils();
        if (this.playerDataHolder == null) {
            this.loadDataCredential();
        }
        new Events(this);
        this.registerCommands();
        new Metrics((Plugin)this);
        Update.checkUpdate(this);
        this.loadEcon();
        this.hologramManager = new HologramManager(this);
        if (this.getServer().getPluginManager().getPlugin("HolographicDisplays") != null) {
            this.useHolographicDisplays = true;
            Bukkit.getConsoleSender().sendMessage("\u00a79[\u00a7bStatsSB\u00a79] \u00a7bHolographicDisplays Detected! \u00a7aEnabling Hologram Capability.");
        }
        if (this.playerDataHolder.getAllNames() != null) {
            if (this.playerDataHolder.getAllNames().size() > 400) {
                Bukkit.getConsoleSender().sendMessage("\u00a79[\u00a7bStatsSB\u00a79] \u00a7cDatabase size is large, could take a few seconds to load the leaderboards.");
            }
            CompletableFuture.runAsync(() -> {
                this.leaderboards.put(StatType.KILL, new Leaderboard(this, StatType.KILL));
                this.leaderboards.put(StatType.DEATH, new Leaderboard(this, StatType.DEATH));
                this.leaderboards.put(StatType.KILL_STREAK, new Leaderboard(this, StatType.KILL_STREAK));
            }).whenComplete((s, t) -> Bukkit.getScheduler().runTask((Plugin)this, () -> this.hologramManager.load()));
        } else {
            this.leaderboards.put(StatType.KILL, new Leaderboard(this, StatType.KILL));
            this.leaderboards.put(StatType.DEATH, new Leaderboard(this, StatType.DEATH));
            this.leaderboards.put(StatType.KILL_STREAK, new Leaderboard(this, StatType.KILL_STREAK));
            this.hologramManager.load();
        }
        DebugLogger.logDebugMessage("\u00a73NOTICE THIS IS A DEBUG VERSION OF THE PLUGIN. NOT RECOMMENDED TO USE ON YOUR PRIMARY SERVER.");
        DebugLogger.logDebugMessage("\u00a73VERSION: \u00a7c" + this.getDescription().getVersion());
        this.playerStatManager = new PlayerStatManager(this);
        this.leaderboardThread = new LeaderboardThread(this, this.fileUtil.getConfigFile().getLeaderboardUpdateTime());
        Utilities.updateStats(this);
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            this.onReload();
        }
    }

    public void reloadFileUtils() {
        if (this.fileUtil == null) {
            this.fileUtil = new FileUtil(this);
        }
        this.fileUtil.setupConfig("config");
    }

    public void onDisable() {
        this.getPlayerDataHolder().getDatabase().shutdown();
    }

    private void loadDataCredential() {
        DataCredential dataCredential;
        new AquaticDatabase(task -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, task), Runnable::run, DebugLogger.isDebug(), this.getLogger());
        long loadStart = System.currentTimeMillis();
        ConfigFile configFile = this.fileUtil.getConfigFile();
        boolean mysql = configFile.getType().equalsIgnoreCase("mysql");
        File dataFolder = this.getDataFolder();
        String tableName = "statssb_stats";
        String databaseName = "statssb_stats";
        if (mysql) {
            DebugLogger.logDebugMessage("MySQLCredential Start");
            dataCredential = new DataCredential().MySQLCredential(configFile.getDatabaseName(), configFile.getHostname(), configFile.getPort(), configFile.getUsername(), configFile.getPassword(), "statssb_stats");
            DebugLogger.logDebugMessage("MySQLCredential Finish");
        } else {
            DebugLogger.logDebugMessage("SQLiteCredential Start");
            dataCredential = new DataCredential().SQLiteCredential(dataFolder, "statssblite_stats", "statssb_stats");
            DebugLogger.logDebugMessage("SQLiteCredential Finish");
        }
        if (this.playerDataHolder != null) {
            DebugLogger.logDebugMessage("Trying to create a new Data Holder when the previous one is already loaded.");
            return;
        }
        this.playerDataHolder = new PlayerDataHolder(this, dataCredential);
        long loadEnd = System.currentTimeMillis();
        long loadElapsedTime = loadEnd - loadStart;
        DebugLogger.logDebugMessage("Data Loading time: " + loadElapsedTime + "ms");
        DebugLogger.logDebugMessage("Loaded " + this.playerDataHolder.getAllPlayerDatas().size() + " users.");
    }

    private void loadEcon() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            Bukkit.getConsoleSender().sendMessage("\u00a79[\u00a7bStatsSB\u00a79] \u00a7bVault Detected! \u00a7aEnabling Economy Capability.");
            this.setupEconomy();
        } else {
            Bukkit.getConsoleSender().sendMessage("\u00a79[\u00a7bStatsSB\u00a79] \u00a7bVault Not Detected! \u00a7cDisabling Economy Capability.");
        }
    }

    public Economy getEconomy() {
        return this.econ;
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public void onReload() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerData playerData = this.getPlayerDataHolder().getOrInsert(player.getUniqueId());
            playerData.setName(player.getName());
            this.playerDataHolder.saveSingle(playerData, false);
            if (!this.getFileUtil().getConfigFile().isScoreboardEnabled()) {
                playerData.getBoard().setAllowed(false);
                playerData.getBoard().remove();
                continue;
            }
            if (this.getFileUtil().getConfigFile().isDisableCertainWorlds() && !Utilities.containsString(player.getWorld().getName(), this.getFileUtil().getConfigFile().getEnabledWorlds())) {
                playerData.getBoard().setAllowed(false);
                playerData.getBoard().remove();
                continue;
            }
            playerData.getBoard().setAllowed(true);
            playerData.getBoard().start();
            Utilities.addToPlayerMaps(this, playerData);
        }
    }

    private void registerCommands() {
        CommandManager statsCM = new CommandManager(this, new StatsBaseCommand(this), new HashMap<String, Subcommand>());
        Objects.requireNonNull(this.getCommand("stats")).setExecutor((CommandExecutor)statsCM);
        CommandManager tsbCM = new CommandManager(this, new TSBBaseCommand(this), new HashMap<String, Subcommand>());
        Objects.requireNonNull(this.getCommand("togglescoreboard")).setExecutor((CommandExecutor)tsbCM);
        HashMap<String, Subcommand> sbSub = new HashMap<String, Subcommand>();
        sbSub.put("help", new SBHelpSubcommand());
        sbSub.put("displays", new SBDisplaysSubcommand(this));
        sbSub.put("hologram", new SBHologramSubcommand(this));
        sbSub.put("reload", new SBReloadSubcommand(this));
        sbSub.put("set", new SBSetSubcommand(this));
        sbSub.put("add", new SBAddSubcommand(this));
        sbSub.put("remove", new SBRemoveSubcommand(this));
        CommandManager sbCM = new CommandManager(this, new SBBaseCommand(this), sbSub);
        Objects.requireNonNull(this.getCommand("statssb")).setExecutor((CommandExecutor)sbCM);
        CommandManager lbCM = new CommandManager(this, new LeaderboardBaseCommand(this), new HashMap<String, Subcommand>());
        Objects.requireNonNull(this.getCommand("leaderboard")).setExecutor((CommandExecutor)lbCM);
    }

    public PlayerData getPlayerData(Player player) {
        return this.playerDataHolder.getOrNull(player.getUniqueId());
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataHolder.getOrNull(uuid);
    }

    public PlayerData getPlayerData(String name) {
        return this.playerDataHolder.getOrNull(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public static StatsSB getInstance() {
        return instance;
    }

    public PlayerStatManager getPlayerStatManager() {
        return this.playerStatManager;
    }

    public FileUtil getFileUtil() {
        return this.fileUtil;
    }

    public Map<StatType, Leaderboard> getLeaderboards() {
        return this.leaderboards;
    }

    public LeaderboardThread getLeaderboardThread() {
        return this.leaderboardThread;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public PlayerDataHolder getPlayerDataHolder() {
        return this.playerDataHolder;
    }

    public boolean isUseHolographicDisplays() {
        return this.useHolographicDisplays;
    }

    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

