/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.util;

import com.google.gson.internal.Primitives;
import io.aquaticlabs.aquaticdata.data.object.SerializableObject;
import io.aquaticlabs.aquaticdata.data.storage.SerializedData;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class StorageUtil {
    private static final List<Class> primitiveList = new ArrayList<Class>(){
        {
            this.add(Integer.class);
            this.add(String.class);
            this.add(Double.class);
            this.add(Long.class);
            this.add(Boolean.class);
            this.add(Float.class);
        }
    };

    public static boolean isPrimitive(Class clazz) {
        clazz = Primitives.wrap((Class)clazz);
        return primitiveList.contains(clazz);
    }

    public static String fromObject(Object object) {
        if (!(object instanceof String)) {
            return object.toString();
        }
        try {
            String objectString = (String)object;
            objectString = objectString.replace("\\", "");
            objectString = objectString.replace("\"", "");
            return objectString;
        }
        catch (Exception e) {
            e.printStackTrace();
            return object.toString();
        }
    }

    public static <T> T fromObject(Object object, Class<T> clazz) {
        if (SerializableObject.class.isAssignableFrom(clazz = Primitives.wrap(clazz))) {
            return StorageUtil.fromSerializable(object, clazz);
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, object.toString());
        }
        Object parsed = StorageUtil.fromObject(object);
        if (clazz != parsed.getClass()) {
            parsed = StorageUtil.doConversion(parsed, clazz);
        }
        return (T)parsed;
    }

    private static <T> Object doConversion(Object parsed, Class<T> clazz) {
        String value = parsed.toString();
        value = value.replace("\\", "");
        value = value.replace("\"", "");
        if (clazz == String.class) {
            return value;
        }
        if (clazz == UUID.class) {
            return UUID.fromString(value);
        }
        if (((clazz = Primitives.wrap(clazz)) == Double.class || clazz == Float.class) && Primitives.wrap((Class)clazz) == Integer.class && value.contains(".")) {
            String[] split = value.split("\\.");
            int noZeroCounter = 0;
            for (char c : split[1].toCharArray()) {
                if (c == '0') continue;
                ++noZeroCounter;
            }
            if (noZeroCounter == 0) {
                value = split[0];
            }
        }
        if (clazz == Integer.class) {
            return Integer.parseInt(value);
        }
        if (clazz == Boolean.class) {
            return value.toCharArray()[0] != '0';
        }
        if (clazz == Long.class) {
            return Long.parseLong(value);
        }
        if (clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz == Double.class) {
            return Double.parseDouble(value);
        }
        throw new IllegalStateException("Failed to convert " + parsed.getClass().getSimpleName() + " to " + clazz.getSimpleName() + " unknown conversion!");
    }

    public static <T> T fromSerializable(Object value, Class<T> clazz) {
        Object object = StorageUtil.getConstructor(clazz).newInstance(new Object[0]);
        ((SerializableObject)object).deserialize(new SerializedData());
        return (T)object;
    }

    public static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor;
    }
}

