/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.type.sqlite;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.aquaticlabs.aquaticdata.data.HikariCPDatabase;
import io.aquaticlabs.aquaticdata.data.object.DataEntry;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.ColumnType;
import io.aquaticlabs.aquaticdata.data.type.DataCredential;
import io.aquaticlabs.aquaticdata.util.DataDebugLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SQLiteDB
extends HikariCPDatabase {
    private final DataCredential dataCredential;
    private final DataObject object;

    public SQLiteDB(DataCredential dataCredential, DataObject object) {
        super(dataCredential.getTableName());
        this.dataCredential = dataCredential;
        this.object = object;
        HikariConfig config = new HikariConfig();
        config.setPoolName("Aquatic Labs Sqlite Pool");
        config.setDriverClassName("org.sqlite.JDBC");
        config.setJdbcUrl("jdbc:sqlite:" + dataCredential.getFolder().getAbsolutePath() + File.separator + dataCredential.getDatabaseName() + ".db");
        config.setConnectionTestQuery("SELECT 1");
        config.setMaxLifetime(60000L);
        config.setMaximumPoolSize(40);
        config.setConnectionTimeout(120000L);
        this.setHikariDataSource(new HikariDataSource(config));
        this.verifyTable(object.getStructure());
    }

    @Override
    public String insertStatement(List<DataEntry<String, String>> columns) {
        ArrayList<DataEntry<String, ColumnType>> col = this.object.getStructure();
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(this.dataCredential.getTableName()).append(" (");
        boolean first = true;
        for (DataEntry<String, String> column : columns) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(column.getKey());
        }
        builder.append(") VALUES (");
        int i = 0;
        first = true;
        for (DataEntry<String, String> column : columns) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            if (((ColumnType)((Object)((DataEntry)col.get(i)).getValue())).isVarchar()) {
                builder.append("'").append(column.getValue().replace("'", "")).append("'");
                ++i;
                continue;
            }
            builder.append(column.getValue());
            ++i;
        }
        builder.append(");");
        DataDebugLog.logDebug(builder.toString());
        return builder.toString();
    }

    @Override
    public String buildUpdateStatementSQL(List<DataEntry<String, String>> columns) {
        DataEntry<String, String> key = columns.get(0);
        ArrayList<DataEntry<String, ColumnType>> structure = this.object.getStructure();
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(this.dataCredential.getTableName()).append(" SET ");
        for (int i = 1; i < columns.size(); ++i) {
            DataEntry<String, String> column = columns.get(i);
            builder.append(column.getKey()).append(" = ");
            if (((ColumnType)((Object)((DataEntry)structure.get(i)).getValue())).isVarchar()) {
                builder.append("'").append(column.getValue().replace("'", "")).append("'");
            } else {
                builder.append(column.getValue());
            }
            if (i >= columns.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(" WHERE ").append(key.getKey()).append(" = '").append(key.getValue()).append("';");
        DataDebugLog.logDebug(builder.toString());
        return builder.toString();
    }

    private void verifyTable(List<DataEntry<String, ColumnType>> columns) {
        this.createTable(columns, false);
    }

    private String buildCreateTableSQL(List<DataEntry<String, ColumnType>> columns, boolean force) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("CREATE TABLE ");
        if (!force) {
            queryBuilder.append("IF NOT EXISTS ");
        }
        queryBuilder.append(this.dataCredential.getTableName()).append(" (").append(columns.get(0).getKey()).append(" ").append(columns.get(0).getValue().getSql()).append(" PRIMARY KEY");
        for (int i = 1; i < columns.size(); ++i) {
            queryBuilder.append(", ").append(columns.get(i).getKey()).append(" ").append(columns.get(i).getValue().getSql()).append(" NOT NULL");
        }
        queryBuilder.append(") ");
        DataDebugLog.logDebug("SQLITE TABLE CREATION: " + queryBuilder.toString());
        return queryBuilder.toString();
    }

    @Override
    public void createTable(List<DataEntry<String, ColumnType>> columns, boolean force) {
        this.executeConnection(conn -> {
            conn.createStatement().executeUpdate(this.buildCreateTableSQL(columns, force));
            return null;
        });
    }
}

