/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.type.mysql;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.aquaticlabs.aquaticdata.data.HikariCPDatabase;
import io.aquaticlabs.aquaticdata.data.object.DataEntry;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.ColumnType;
import io.aquaticlabs.aquaticdata.data.type.DataCredential;
import io.aquaticlabs.aquaticdata.util.DataDebugLog;
import java.util.ArrayList;
import java.util.List;

public class MySQLDB
extends HikariCPDatabase {
    private final DataCredential dataCredential;
    private final DataObject object;

    public MySQLDB(DataCredential dataCredential, DataObject object) {
        super(dataCredential.getTableName());
        this.dataCredential = dataCredential;
        this.object = object;
        HikariConfig config = new HikariConfig();
        config.setPoolName("Aquatic Labs MySql Pool");
        config.setDriverClassName("com.mysql.jdbc.Driver");
        String url = "jdbc:mysql://" + dataCredential.getHostname() + ":" + dataCredential.getPort() + "/" + dataCredential.getDatabaseName();
        url = url + "?allowPublicKeyRetrieval=" + dataCredential.isAllowPublicKeyRetrieval() + "&useSSL=" + dataCredential.isUseSSL();
        config.setJdbcUrl(url);
        config.setUsername(dataCredential.getUsername());
        config.setPassword(dataCredential.getPassword());
        config.addDataSourceProperty("cachePrepStmts", true);
        config.addDataSourceProperty("prepStmtCacheSize", 250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
        config.addDataSourceProperty("useServerPrepStmts", true);
        config.addDataSourceProperty("useLocalSessionState", true);
        config.addDataSourceProperty("rewriteBatchedStatements", true);
        config.addDataSourceProperty("cacheResultSetMetadata", true);
        config.addDataSourceProperty("cacheServerConfiguration", true);
        config.addDataSourceProperty("elideSetAutoCommits", true);
        config.addDataSourceProperty("maintainTimeStats", false);
        config.addDataSourceProperty("alwaysSendSetIsolation", false);
        config.addDataSourceProperty("cacheCallableStmts", true);
        config.setConnectionTimeout(120000L);
        config.setMaximumPoolSize(10);
        this.setHikariDataSource(new HikariDataSource(config));
        this.verifyTable(object.getStructure());
    }

    @Override
    public String insertStatement(List<DataEntry<String, String>> columns) {
        ArrayList<DataEntry<String, ColumnType>> structure = this.object.getStructure();
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(this.dataCredential.getTableName()).append(" (");
        int i = 0;
        for (DataEntry<String, String> column : columns) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(column.getKey());
            ++i;
        }
        builder.append(") VALUES (");
        i = 0;
        for (DataEntry<String, String> column : columns) {
            if (column.getValue() == null) continue;
            if (i > 0) {
                builder.append(", ");
            }
            if (((ColumnType)((Object)((DataEntry)structure.get(i)).getValue())).isVarchar()) {
                builder.append("'").append(column.getValue().replace("'", "")).append("'");
            } else {
                builder.append(column.getValue());
            }
            ++i;
        }
        builder.append(");");
        DataDebugLog.logDebug(builder.toString());
        return builder.toString();
    }

    @Override
    public String buildUpdateStatementSQL(List<DataEntry<String, String>> columns) {
        DataEntry<String, String> key = columns.get(0);
        ArrayList<DataEntry<String, ColumnType>> structure = this.object.getStructure();
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(this.dataCredential.getTableName()).append(" SET ");
        for (int i = 1; i < columns.size(); ++i) {
            DataEntry<String, String> column = columns.get(i);
            builder.append(column.getKey()).append(" = ");
            if (((ColumnType)((Object)((DataEntry)structure.get(i)).getValue())).isVarchar()) {
                builder.append("'").append(column.getValue().replace("'", "")).append("'");
            } else {
                builder.append(column.getValue());
            }
            if (i >= columns.size() - 1) continue;
            builder.append(", ");
        }
        builder.append(" WHERE ").append(key.getKey()).append(" = '").append(key.getValue()).append("';");
        DataDebugLog.logDebug("MYSQL UPDATE STATEMENT: " + builder.toString());
        return builder.toString();
    }

    private void verifyTable(List<DataEntry<String, ColumnType>> columns) {
        this.createTable(columns, false);
    }

    private String buildCreateTableSQL(List<DataEntry<String, ColumnType>> columns, boolean force) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("CREATE TABLE ");
        if (!force) {
            queryBuilder.append("IF NOT EXISTS ");
        }
        queryBuilder.append(this.dataCredential.getTableName()).append(" (");
        for (int i = 0; i < columns.size(); ++i) {
            DataEntry<String, ColumnType> column = columns.get(i);
            queryBuilder.append(column.getKey()).append(" ").append(column.getValue().getSql());
            if (i == columns.size() - 1) continue;
            queryBuilder.append(", ");
        }
        queryBuilder.append(", PRIMARY KEY ( ").append(columns.get(0).getKey()).append(" ));");
        DataDebugLog.logDebug("MYSQL TABLE CREATION: " + queryBuilder.toString());
        return queryBuilder.toString();
    }

    @Override
    public void createTable(List<DataEntry<String, ColumnType>> columns, boolean force) {
        this.executeConnection(conn -> {
            conn.createStatement().executeUpdate(this.buildCreateTableSQL(columns, force));
            return null;
        });
    }
}

