/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.type;

import io.aquaticlabs.aquaticdata.data.ADatabase;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.type.mysql.MySQLDB;
import io.aquaticlabs.aquaticdata.data.type.sqlite.SQLiteDB;
import java.io.File;

public class DataCredential {
    private String databaseName;
    private String hostname;
    private int port = 3306;
    private String username;
    private String password;
    private boolean useSSL = false;
    private boolean allowPublicKeyRetrieval = true;
    private String tableName;
    private File folder;

    public DataCredential MySQLCredential(String databaseName, String hostname, int port, String username, String password, String tableName) {
        this.databaseName = databaseName;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.tableName = tableName;
        return this;
    }

    public DataCredential SQLiteCredential(File folder, String databaseName, String tableName) {
        this.folder = folder;
        this.databaseName = databaseName;
        this.tableName = tableName;
        return this;
    }

    public ADatabase build(DataObject object) {
        if (this.password != null) {
            return new MySQLDB(this, object);
        }
        return new SQLiteDB(this, object);
    }

    public DataCredential databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public DataCredential hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public DataCredential port(int port) {
        this.port = port;
        return this;
    }

    public DataCredential username(String username) {
        this.username = username;
        return this;
    }

    public DataCredential password(String password) {
        this.password = password;
        return this;
    }

    public DataCredential tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public DataCredential folder(File folder) {
        this.folder = folder;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return this;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isAllowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public String getTableName() {
        return this.tableName;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setAllowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) {
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }
}

