/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.storage;

import io.aquaticlabs.aquaticdata.AquaticDatabase;
import io.aquaticlabs.aquaticdata.data.ADatabase;
import io.aquaticlabs.aquaticdata.data.cache.ModelCachedData;
import io.aquaticlabs.aquaticdata.data.object.DataEntry;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.ColumnType;
import io.aquaticlabs.aquaticdata.data.storage.SerializedData;
import io.aquaticlabs.aquaticdata.data.storage.Storage;
import io.aquaticlabs.aquaticdata.data.storage.StorageMode;
import io.aquaticlabs.aquaticdata.data.type.DataCredential;
import io.aquaticlabs.aquaticdata.data.type.mysql.MySQLDB;
import io.aquaticlabs.aquaticdata.util.DataDebugLog;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public abstract class StorageHolder<T extends DataObject>
extends Storage<T> {
    private ADatabase database;
    private Class<T> clazz;
    private final Map<Class<? extends T>, Constructor<? extends T>> constructorMap = new ConcurrentHashMap<Class<? extends T>, Constructor<? extends T>>();

    protected StorageHolder(DataCredential dataCredential, Class<T> clazz, StorageMode storageMode) {
        DataObject t;
        try {
            t = (DataObject)this.constructorOf(clazz).newInstance(new Object[0]);
        }
        catch (Exception c) {
            c.printStackTrace();
            DataDebugLog.logError("FAILED TO CREATE DUMMY (" + clazz.getName() + ") OBJECT. STOPPING BOOTUP!");
            return;
        }
        this.database = dataCredential.build(t);
        this.clazz = clazz;
        this.addVariant(this.database.getTable(), clazz);
        this.initStorageMode(storageMode);
        long startTime = System.currentTimeMillis();
        this.confirmTable(t, false);
        long endTime = System.currentTimeMillis();
        DataDebugLog.logDebug("Confirm Table: " + (endTime - startTime) + "ms");
    }

    public void loadAll(boolean async) {
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        runner.accept(() -> this.database.executeConnection(conn -> {
            block21: {
                T dummy;
                try {
                    dummy = this.construct(this.clazz);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DataDebugLog.logDebug("Failed to Construct <T>(" + this.clazz.getName() + ") Class");
                    return null;
                }
                ArrayList<DataEntry<String, ColumnType>> structure = ((DataObject)dummy).getStructure();
                try {
                    ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.database.getTable());
                    Throwable throwable = null;
                    block15: while (true) {
                        try {
                            while (rs.next()) {
                                LinkedList<DataEntry<String, Object>> data = new LinkedList<DataEntry<String, Object>>();
                                for (DataEntry<String, ColumnType> entry : structure) {
                                    data.add(new DataEntry<String, Object>(entry.getKey(), rs.getObject(entry.getKey())));
                                }
                                SerializedData serializedData = new SerializedData();
                                serializedData.fromQuery(data);
                                try {
                                    T dumb = this.construct(this.clazz);
                                    dumb.deserialize(serializedData);
                                    this.loadIntoCache(dumb, serializedData);
                                    this.add(dumb);
                                    continue block15;
                                }
                                catch (Exception exception) {
                                    DataDebugLog.logDebug("Failed to deserialize class, with data: " + serializedData.toString());
                                    exception.printStackTrace();
                                }
                            }
                            break block21;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }));
    }

    private void loadIntoCache(T object, SerializedData data) {
        ModelCachedData cache = this.getDataCache().computeIfAbsent(((DataObject)object).getKey().toString(), key -> new ModelCachedData());
        for (DataEntry<String, String> entryList : data.toColumnList(((DataObject)object).getStructure())) {
            String column = entryList.getKey();
            String value = entryList.getValue();
            cache.add(column, value);
        }
    }

    public void load(DataEntry<String, ?> key, boolean async) {
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        runner.accept(() -> this.database.executeNonLockConnection(conn -> {
            if (!this.doesEntryExist(conn, key)) {
                return false;
            }
            T dummy = this.construct(this.clazz);
            ArrayList<DataEntry<String, ColumnType>> structure = ((DataObject)dummy).getStructure();
            try (ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.database.getTable() + " WHERE " + (String)key.getKey() + " = '" + key.getValue() + "'");){
                int i = 1;
                LinkedList<DataEntry<String, Object>> data = new LinkedList<DataEntry<String, Object>>();
                for (DataEntry<String, ColumnType> entry : structure) {
                    data.add(new DataEntry<String, Object>(entry.getKey(), rs.getObject(i)));
                    ++i;
                }
                DataDebugLog.logDebug("SELECT * FROM " + this.database.getTable() + " WHERE " + (String)key.getKey() + " = '" + key.getValue() + "'");
                SerializedData serializedData = new SerializedData();
                serializedData.fromQuery(data);
                dummy.deserialize(serializedData);
                this.loadIntoCache(dummy, serializedData);
                this.add(dummy);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        }));
    }

    public T load(DataEntry<String, ?> key, boolean async, boolean persistent) {
        T t;
        if (this.getStorageMode() == StorageMode.LOAD_AND_TIMEOUT) {
            this.getCache().getObjectCache().cleanUp();
        }
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        try {
            t = this.construct(this.clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            DataDebugLog.logDebug("Failed to Construct <T>(" + this.clazz.getName() + ") Class");
            return null;
        }
        ArrayList<DataEntry<String, ColumnType>> structure = ((DataObject)t).getStructure();
        T dummy = this.construct();
        if (dummy == null) {
            return null;
        }
        runner.accept(() -> this.database.executeNonLockConnection(conn -> {
            if (!this.doesEntryExist(conn, key)) {
                return null;
            }
            try (ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + this.database.getTable() + " WHERE " + (String)key.getKey() + " = '" + key.getValue() + "'");){
                rs.next();
                int i = 1;
                LinkedList<DataEntry<String, Object>> data = new LinkedList<DataEntry<String, Object>>();
                for (DataEntry entry : structure) {
                    data.add(new DataEntry(entry.getKey(), rs.getObject(i)));
                    ++i;
                }
                SerializedData serializedData = new SerializedData();
                serializedData.fromQuery(data);
                dummy.deserialize(serializedData);
                if (!persistent) {
                    this.loadIntoCache(dummy, serializedData);
                }
                DataObject dataObject = dummy;
                return dataObject;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }));
        return dummy;
    }

    public void saveLoaded(boolean async) {
        this.saveLoaded(async, null);
    }

    public void saveList(List<T> list, boolean async, Runnable run) {
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        runner.accept(() -> this.database.executeConnection(conn -> {
            for (DataObject object : list) {
                SerializedData data = new SerializedData();
                object.serialize(data);
                List<DataEntry<String, String>> columnList = data.toColumnList(object.getStructure());
                List<DataEntry<String, String>> needsUpdate = this.buildNeedsUpdate(object, data);
                if (needsUpdate.isEmpty()) {
                    DataDebugLog.logDebug("Needs update is empty. no need for updating");
                    return needsUpdate;
                }
                if (this.doesEntryExist(conn, columnList.get(0))) {
                    try {
                        conn.createStatement().executeUpdate(this.database.buildUpdateStatementSQL(needsUpdate));
                    }
                    catch (SQLException e) {
                        DataDebugLog.logDebug("Fail Updating Data: " + e.getMessage());
                    }
                    continue;
                }
                try {
                    conn.createStatement().executeUpdate(this.database.insertStatement(columnList));
                }
                catch (SQLException e) {
                    DataDebugLog.logDebug("Fail Inserting Data: " + e.getMessage());
                }
            }
            if (run != null) {
                runner.accept(run);
            }
            return null;
        }));
    }

    public void saveLoaded(boolean async, Runnable run) {
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        runner.accept(() -> this.database.executeConnection(conn -> {
            for (DataObject object : this) {
                SerializedData data = new SerializedData();
                object.serialize(data);
                List<DataEntry<String, String>> columnList = data.toColumnList(object.getStructure());
                List<DataEntry<String, String>> needsUpdate = this.buildNeedsUpdate(object, data);
                if (needsUpdate.isEmpty()) {
                    DataDebugLog.logDebug("Needs update is empty. no need for updating");
                    return needsUpdate;
                }
                if (this.doesEntryExist(conn, columnList.get(0))) {
                    try {
                        conn.createStatement().executeUpdate(this.database.buildUpdateStatementSQL(needsUpdate));
                    }
                    catch (SQLException e) {
                        DataDebugLog.logDebug("Fail Updating Data: " + e.getMessage());
                    }
                    continue;
                }
                try {
                    conn.createStatement().executeUpdate(this.database.insertStatement(columnList));
                }
                catch (SQLException e) {
                    DataDebugLog.logDebug("Fail Inserting Data: " + e.getMessage());
                }
            }
            if (run != null) {
                runner.accept(run);
            }
            return true;
        }));
    }

    private List<DataEntry<String, String>> buildNeedsUpdate(T object, SerializedData data) {
        ModelCachedData cache = this.getDataCache().computeIfAbsent(((DataObject)object).getKey().toString(), key -> new ModelCachedData());
        ArrayList<DataEntry<String, String>> needsUpdate = new ArrayList<DataEntry<String, String>>();
        for (DataEntry<String, String> entryList : data.toColumnList(((DataObject)object).getStructure())) {
            String column = entryList.getKey();
            String value = entryList.getValue();
            if (!data.getValue(entryList.getKey()).isPresent()) {
                needsUpdate.add(new DataEntry<String, String>(column, value));
                DataDebugLog.logDebug("Needs Update: " + column + " " + value);
                continue;
            }
            if (!cache.isNotUpdated(column, value)) continue;
            DataDebugLog.logDebug("Needs Update: " + column + " " + value);
            needsUpdate.add(new DataEntry<String, String>(column, value));
        }
        if (needsUpdate.isEmpty()) {
            return needsUpdate;
        }
        String key2 = ((DataObject)object).getStructure().get(0).getKey();
        String existingKey = (String)((DataEntry)needsUpdate.get(0)).getKey();
        if (!existingKey.equalsIgnoreCase(key2)) {
            Optional<Object> value = data.getValue(key2);
            value.ifPresent(o -> needsUpdate.add(0, new DataEntry<String, String>(key2, o.toString())));
        }
        return needsUpdate;
    }

    public void saveSingle(T object, boolean async) {
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        ModelCachedData cache = this.getDataCache().computeIfAbsent(((DataObject)object).getKey().toString(), key -> new ModelCachedData());
        SerializedData data = new SerializedData();
        object.serialize(data);
        ArrayList<DataEntry<String, String>> needsUpdate = new ArrayList<DataEntry<String, String>>();
        for (DataEntry<String, String> entryList : data.toColumnList(((DataObject)object).getStructure())) {
            String column = entryList.getKey();
            String value = entryList.getValue();
            if (!data.getValue(entryList.getKey()).isPresent()) {
                needsUpdate.add(new DataEntry<String, String>(column, value));
                DataDebugLog.logDebug("Needs Update: " + column + " " + value);
                continue;
            }
            if (!cache.isNotUpdated(column, value)) continue;
            DataDebugLog.logDebug("Needs Update: " + column + " " + value);
            needsUpdate.add(new DataEntry<String, String>(column, value));
        }
        if (needsUpdate.isEmpty()) {
            DataDebugLog.logDebug("Needs update is empty. no need for updating");
            return;
        }
        String key2 = ((DataObject)object).getStructure().get(0).getKey();
        String existingKey = (String)((DataEntry)needsUpdate.get(0)).getKey();
        if (!existingKey.equalsIgnoreCase(key2)) {
            Optional<Object> value = data.getValue(key2);
            value.ifPresent(o -> needsUpdate.add(0, new DataEntry<String, String>(key2, o.toString())));
        }
        runner.accept(() -> this.database.executeNonLockConnection(conn -> {
            List<DataEntry<String, String>> columnList = data.toColumnList(object.getStructure());
            if (this.doesEntryExist(conn, columnList.get(0))) {
                try {
                    conn.createStatement().executeUpdate(this.database.buildUpdateStatementSQL(needsUpdate));
                    DataDebugLog.logDebug("Success Updating Data");
                }
                catch (SQLException e) {
                    DataDebugLog.logDebug("Fail Updating Data: " + e.getMessage());
                }
            } else {
                try {
                    conn.createStatement().executeUpdate(this.database.insertStatement(columnList));
                    DataDebugLog.logDebug("Success Inserting Data");
                }
                catch (SQLException e) {
                    DataDebugLog.logDebug("Fail Inserting Data: " + e.getMessage());
                }
            }
            return true;
        }));
    }

    public boolean doesEntryExist(Connection conn, DataEntry<String, ?> key) {
        String sql = "SELECT 1 FROM " + this.database.getTable() + " WHERE " + key.getKey() + " = ?";
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(sql);
            statement.setObject(1, key.getValue());
            resultSet = statement.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while checking if entry exists in database", e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int getDataSize(Connection conn) {
        String sql = "SELECT COUNT(*) FROM " + this.database.getTable();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = conn.prepareStatement(sql);
            resultSet = statement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while checking if entry exists in database", e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void confirmTable(T object, boolean async) {
        HashMap needsChange = new HashMap();
        Consumer<Runnable> runner = AquaticDatabase.getInstance().getRunner(async);
        String tempTableName = "tempTable";
        DataDebugLog.logDebug("confirm table?");
        runner.accept(() -> this.database.executeConnection(conn -> {
            try (PreparedStatement preparedStatement = conn.prepareStatement("SELECT * FROM " + this.database.getTable() + ";");
                 ResultSet resultSet = preparedStatement.executeQuery();){
                int cols = resultSet.getMetaData().getColumnCount();
                if (cols != object.getStructure().size()) {
                    needsChange.put(1, "dummy");
                }
                for (int curCol = 1; curCol < cols; ++curCol) {
                    ColumnType colType = ColumnType.matchType(resultSet.getMetaData().getColumnTypeName(curCol));
                    String string = resultSet.getMetaData().getColumnTypeName(curCol);
                    DataDebugLog.logDebug(string);
                    if (colType == null) {
                        needsChange.put(curCol, resultSet.getMetaData().getColumnName(curCol));
                        continue;
                    }
                    if (ColumnType.isSimilarMatching(object.getStructure().get(curCol - 1).getValue(), colType)) continue;
                    needsChange.put(curCol, resultSet.getMetaData().getColumnName(curCol));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to get Database Size", e);
            }
            DataDebugLog.logDebug(needsChange);
            if (!needsChange.isEmpty()) {
                PreparedStatement preparedStatement;
                Object stmt;
                if (this.database instanceof MySQLDB) {
                    for (Map.Entry e : needsChange.entrySet()) {
                        stmt = "ALTER TABLE " + this.database.getTable() + " MODIFY COLUMN `" + (String)e.getValue() + "` " + object.getStructure().get((Integer)e.getKey()).getValue().getSql() + " NOT NULL DEFAULT '0';;";
                        DataDebugLog.logDebug(stmt);
                        try {
                            preparedStatement = conn.prepareStatement((String)stmt);
                            Throwable cols = null;
                            try {
                                preparedStatement.executeUpdate();
                            }
                            catch (Throwable curCol) {
                                cols = curCol;
                                throw curCol;
                            }
                            finally {
                                if (preparedStatement == null) continue;
                                if (cols != null) {
                                    try {
                                        preparedStatement.close();
                                    }
                                    catch (Throwable curCol) {
                                        cols.addSuppressed(curCol);
                                    }
                                    continue;
                                }
                                preparedStatement.close();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new IllegalStateException("Failed to Alter Table.", ex);
                        }
                    }
                    return null;
                }
                String stmt1 = "ALTER TABLE " + this.database.getTable() + " RENAME TO " + tempTableName + ";";
                DataDebugLog.logDebug(stmt1);
                try {
                    PreparedStatement preparedStatement2 = conn.prepareStatement(stmt1);
                    stmt = null;
                    try {
                        preparedStatement2.executeUpdate();
                    }
                    catch (Throwable ex) {
                        stmt = ex;
                        throw ex;
                    }
                    finally {
                        if (preparedStatement2 != null) {
                            if (stmt != null) {
                                try {
                                    preparedStatement2.close();
                                }
                                catch (Throwable ex) {
                                    ((Throwable)stmt).addSuppressed(ex);
                                }
                            } else {
                                preparedStatement2.close();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    DataDebugLog.logDebug("Failed to Alter Table. " + ex.getMessage());
                }
                ArrayList<DataEntry<String, ColumnType>> structure = object.getStructure();
                this.database.createTable(structure, true);
                DataDebugLog.logDebug("copy");
                try (ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + tempTableName);){
                    T dummy = this.construct();
                    while (rs.next()) {
                        LinkedList<DataEntry<String, Object>> data = new LinkedList<DataEntry<String, Object>>();
                        for (DataEntry dataEntry : structure) {
                            try {
                                rs.findColumn((String)dataEntry.getKey());
                            }
                            catch (SQLException sql) {
                                data.add(new DataEntry(dataEntry.getKey(), object.getDefaultDataValue((String)dataEntry.getKey())));
                                continue;
                            }
                            data.add(new DataEntry(dataEntry.getKey(), rs.getObject((String)dataEntry.getKey())));
                        }
                        SerializedData serializedData = new SerializedData();
                        serializedData.fromQuery(data);
                        assert (dummy != null);
                        dummy.deserialize(serializedData);
                        try {
                            conn.createStatement().executeUpdate(this.database.insertStatement(serializedData.toColumnList(((DataObject)dummy).getStructure())));
                            DataDebugLog.logDebug("Success Inserting New Data");
                        }
                        catch (SQLException sQLException) {
                            DataDebugLog.logDebug("Fail Inserting New Data: " + sQLException.getMessage());
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                String dropStmt = "DROP TABLE '" + tempTableName + "'";
                try {
                    preparedStatement = conn.prepareStatement(dropStmt);
                    Throwable throwable = null;
                    try {
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (preparedStatement != null) {
                            if (throwable != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                preparedStatement.close();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    DataDebugLog.logDebug("Failed to Drop temp Table. " + ex.getMessage());
                }
            }
            return null;
        }));
        if (!needsChange.isEmpty()) {
            DataDebugLog.logDebug("table altered, moving to copying");
            DataDebugLog.logDebug("Needs: " + needsChange);
            return;
        }
        DataDebugLog.logDebug("table unchanged.");
    }

    private T construct() {
        DataObject dummy;
        try {
            dummy = (DataObject)this.constructorOf(this.clazz).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            DataDebugLog.logDebug("Failed to Construct Dummy Class <T>(" + this.clazz.getName() + ") Class");
            return null;
        }
        return (T)dummy;
    }

    public <B extends T> B construct(Class<B> clazz) {
        return (B)((DataObject)this.constructorMap.computeIfAbsent(clazz, key -> {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to find empty constructor for " + clazz);
            }
        }).newInstance(new Object[0]));
    }

    public ADatabase getDatabase() {
        return this.database;
    }

    @Override
    protected Map<Class<? extends T>, Constructor<? extends T>> getConstructorMap() {
        return this.constructorMap;
    }
}

