/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.storage;

import io.aquaticlabs.aquaticdata.data.cache.ModelCachedData;
import io.aquaticlabs.aquaticdata.data.cache.ObjectCache;
import io.aquaticlabs.aquaticdata.data.object.DataObject;
import io.aquaticlabs.aquaticdata.data.storage.StorageMode;
import io.aquaticlabs.aquaticdata.util.ConstuctorFailThrowable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public abstract class Storage<T extends DataObject>
implements Iterable<T> {
    private final Map<String, Class<T>> variants = new HashMap<String, Class<T>>();
    private final Map<Class<? extends T>, Constructor<? extends T>> constructorMap = new ConcurrentHashMap<Class<? extends T>, Constructor<? extends T>>();
    private ObjectCache cache;
    private final Map<String, ModelCachedData> dataCache = new ConcurrentHashMap<String, ModelCachedData>();
    private StorageMode storageMode = StorageMode.LOAD_AND_TIMEOUT;
    private int timeOutTime = 1;

    protected void initStorageMode(StorageMode storageMode) {
        this.storageMode = storageMode;
        if (storageMode == StorageMode.LOAD_AND_TIMEOUT) {
            this.cache = new ObjectCache(this, this.timeOutTime, TimeUnit.MINUTES);
        }
        if (storageMode == StorageMode.LOAD_AND_STORE) {
            // empty if block
        }
    }

    public void addVariant(String variant, Class<T> clazz) {
        this.variants.put(variant, clazz);
    }

    protected abstract void onAdd(T var1);

    protected abstract void onRemove(T var1);

    public void add(T object, boolean hold) {
        this.tryCleanCache();
        this.onAdd(object);
        if (!hold) {
            switch (this.storageMode) {
                case LOAD_AND_TIMEOUT: {
                    this.cache.getObjectCache().put(((DataObject)object).getKey(), object);
                    break;
                }
                case LOAD_AND_STORE: {
                    break;
                }
                case LOAD_AND_REMOVE: {
                    this.onRemove(object);
                }
            }
        }
    }

    public void add(T object) {
        this.add(object, false);
    }

    public void remove(T object) {
        this.tryCleanCache();
        this.onRemove(object);
        if (this.storageMode == StorageMode.LOAD_AND_TIMEOUT) {
            this.cache.getObjectCache().invalidate(object);
        }
    }

    public abstract void removeDataObj(DataObject var1);

    private void tryCleanCache() {
        if (this.storageMode == StorageMode.LOAD_AND_TIMEOUT) {
            this.getCache().getObjectCache().cleanUp();
        }
    }

    protected Constructor<T> constructorOf(Class<T> type) throws ConstuctorFailThrowable {
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConstuctorFailThrowable("Please ensure that the type '" + type.getSimpleName() + "' has a single-arg constructor.");
        }
        return constructor;
    }

    public Map<String, Class<T>> getVariants() {
        return this.variants;
    }

    protected Map<Class<? extends T>, Constructor<? extends T>> getConstructorMap() {
        return this.constructorMap;
    }

    public ObjectCache getCache() {
        return this.cache;
    }

    protected Map<String, ModelCachedData> getDataCache() {
        return this.dataCache;
    }

    public StorageMode getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(StorageMode storageMode) {
        this.storageMode = storageMode;
    }

    public int getTimeOutTime() {
        return this.timeOutTime;
    }

    public void setTimeOutTime(int timeOutTime) {
        this.timeOutTime = timeOutTime;
    }
}

