/*
 * Decompiled with CFR 0.152.
 */
package io.aquaticlabs.aquaticdata.data.storage;

import io.aquaticlabs.aquaticdata.data.object.DataEntry;
import io.aquaticlabs.aquaticdata.data.storage.ColumnType;
import io.aquaticlabs.aquaticdata.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class SerializedData {
    private final HashMap<String, Object> values = new HashMap();

    public <T> T applyAs(String key, Class<T> castingClass, Supplier<T> defaultValue) {
        return (T)this.getValue(key).map(element -> StorageUtil.fromObject(element, castingClass)).orElseGet(defaultValue == null ? () -> null : defaultValue);
    }

    public <T> T applyAs(String field, Class<T> clazz) {
        return this.applyAs(field, clazz, null);
    }

    public Optional<Object> getValue(String field) {
        Object element = this.values.get(field);
        return element == null ? Optional.empty() : Optional.of(element);
    }

    public void write(String field, Object object) {
        this.values.put(field, object);
    }

    public SerializedData fromQuery(List<DataEntry<String, Object>> objectValues) {
        for (DataEntry<String, Object> objectValue : objectValues) {
            this.write(objectValue.getKey(), objectValue.getValue());
        }
        return this;
    }

    public List<DataEntry<String, String>> toColumnList(List<DataEntry<String, ColumnType>> columns) {
        ArrayList<DataEntry<String, String>> data = new ArrayList<DataEntry<String, String>>();
        for (DataEntry<String, ColumnType> entry : columns) {
            data.add(new DataEntry<String, String>(entry.getKey(), this.applyAs(entry.getKey(), String.class)));
        }
        return data;
    }

    public HashMap<String, Object> getValues() {
        return this.values;
    }
}

